package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCacheSecurityGroupRequest(
    cacheSecurityGroupName: String,
    description: String,
    tags: Option[Iterable[zio.aws.elasticache.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest = {
    import CreateCacheSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest
      .builder()
      .cacheSecurityGroupName(cacheSecurityGroupName: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateCacheSecurityGroupRequest.ReadOnly =
    zio.aws.elasticache.model.CreateCacheSecurityGroupRequest
      .wrap(buildAwsValue())
}
object CreateCacheSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheSecurityGroupRequest =
      zio.aws.elasticache.model.CreateCacheSecurityGroupRequest(
        cacheSecurityGroupName,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheSecurityGroupName: String
    def description: String
    def tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getCacheSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheSecurityGroupName)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest
  ) extends zio.aws.elasticache.model.CreateCacheSecurityGroupRequest.ReadOnly {
    override val cacheSecurityGroupName: String =
      impl.cacheSecurityGroupName(): String
    override val description: String = impl.description(): String
    override val tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSecurityGroupRequest
  ): zio.aws.elasticache.model.CreateCacheSecurityGroupRequest.ReadOnly =
    new Wrapper(impl)
}
