package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteCacheClusterResponse(
    cacheCluster: Option[zio.aws.elasticache.model.CacheCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse = {
    import DeleteCacheClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse
      .builder()
      .optionallyWith(cacheCluster.map(value => value.buildAwsValue()))(
        _.cacheCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly =
    zio.aws.elasticache.model.DeleteCacheClusterResponse.wrap(buildAwsValue())
}
object DeleteCacheClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DeleteCacheClusterResponse =
      zio.aws.elasticache.model
        .DeleteCacheClusterResponse(cacheCluster.map(value => value.asEditable))
    def cacheCluster: Option[zio.aws.elasticache.model.CacheCluster.ReadOnly]
    def getCacheCluster
        : ZIO[Any, AwsError, zio.aws.elasticache.model.CacheCluster.ReadOnly] =
      AwsError.unwrapOptionField("cacheCluster", cacheCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse
  ) extends zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly {
    override val cacheCluster
        : Option[zio.aws.elasticache.model.CacheCluster.ReadOnly] = scala
      .Option(impl.cacheCluster())
      .map(value => zio.aws.elasticache.model.CacheCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteCacheClusterResponse
  ): zio.aws.elasticache.model.DeleteCacheClusterResponse.ReadOnly =
    new Wrapper(impl)
}
