package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeGroup(
    nodeGroupId: Option[String] = None,
    status: Option[String] = None,
    primaryEndpoint: Option[zio.aws.elasticache.model.Endpoint] = None,
    readerEndpoint: Option[zio.aws.elasticache.model.Endpoint] = None,
    slots: Option[String] = None,
    nodeGroupMembers: Option[
      Iterable[zio.aws.elasticache.model.NodeGroupMember]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroup = {
    import NodeGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroup
      .builder()
      .optionallyWith(nodeGroupId.map(value => value: java.lang.String))(
        _.nodeGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(primaryEndpoint.map(value => value.buildAwsValue()))(
        _.primaryEndpoint
      )
      .optionallyWith(readerEndpoint.map(value => value.buildAwsValue()))(
        _.readerEndpoint
      )
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(
        nodeGroupMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroupMembers)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.NodeGroup.ReadOnly =
    zio.aws.elasticache.model.NodeGroup.wrap(buildAwsValue())
}
object NodeGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroup =
      zio.aws.elasticache.model.NodeGroup(
        nodeGroupId.map(value => value),
        status.map(value => value),
        primaryEndpoint.map(value => value.asEditable),
        readerEndpoint.map(value => value.asEditable),
        slots.map(value => value),
        nodeGroupMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nodeGroupId: Option[String]
    def status: Option[String]
    def primaryEndpoint: Option[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def readerEndpoint: Option[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def slots: Option[String]
    def nodeGroupMembers
        : Option[List[zio.aws.elasticache.model.NodeGroupMember.ReadOnly]]
    def getNodeGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPrimaryEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("primaryEndpoint", primaryEndpoint)
    def getReaderEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("readerEndpoint", readerEndpoint)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getNodeGroupMembers: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroupMember.ReadOnly
    ]] = AwsError.unwrapOptionField("nodeGroupMembers", nodeGroupMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroup
  ) extends zio.aws.elasticache.model.NodeGroup.ReadOnly {
    override val nodeGroupId: Option[String] =
      scala.Option(impl.nodeGroupId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val primaryEndpoint
        : Option[zio.aws.elasticache.model.Endpoint.ReadOnly] = scala
      .Option(impl.primaryEndpoint())
      .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val readerEndpoint
        : Option[zio.aws.elasticache.model.Endpoint.ReadOnly] = scala
      .Option(impl.readerEndpoint())
      .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val slots: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override val nodeGroupMembers
        : Option[List[zio.aws.elasticache.model.NodeGroupMember.ReadOnly]] =
      scala
        .Option(impl.nodeGroupMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.NodeGroupMember.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroup
  ): zio.aws.elasticache.model.NodeGroup.ReadOnly = new Wrapper(impl)
}
