package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LogDeliveryConfiguration(
    logType: Option[zio.aws.elasticache.model.LogType] = None,
    destinationType: Option[zio.aws.elasticache.model.DestinationType] = None,
    destinationDetails: Option[zio.aws.elasticache.model.DestinationDetails] =
      None,
    logFormat: Option[zio.aws.elasticache.model.LogFormat] = None,
    status: Option[zio.aws.elasticache.model.LogDeliveryConfigurationStatus] =
      None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration = {
    import LogDeliveryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration
      .builder()
      .optionallyWith(logType.map(value => value.unwrap))(_.logType)
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(destinationDetails.map(value => value.buildAwsValue()))(
        _.destinationDetails
      )
      .optionallyWith(logFormat.map(value => value.unwrap))(_.logFormat)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly =
    zio.aws.elasticache.model.LogDeliveryConfiguration.wrap(buildAwsValue())
}
object LogDeliveryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.LogDeliveryConfiguration =
      zio.aws.elasticache.model.LogDeliveryConfiguration(
        logType.map(value => value),
        destinationType.map(value => value),
        destinationDetails.map(value => value.asEditable),
        logFormat.map(value => value),
        status.map(value => value),
        message.map(value => value)
      )
    def logType: Option[zio.aws.elasticache.model.LogType]
    def destinationType: Option[zio.aws.elasticache.model.DestinationType]
    def destinationDetails
        : Option[zio.aws.elasticache.model.DestinationDetails.ReadOnly]
    def logFormat: Option[zio.aws.elasticache.model.LogFormat]
    def status: Option[zio.aws.elasticache.model.LogDeliveryConfigurationStatus]
    def message: Option[String]
    def getLogType: ZIO[Any, AwsError, zio.aws.elasticache.model.LogType] =
      AwsError.unwrapOptionField("logType", logType)
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getDestinationDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.DestinationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("destinationDetails", destinationDetails)
    def getLogFormat: ZIO[Any, AwsError, zio.aws.elasticache.model.LogFormat] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.LogDeliveryConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration
  ) extends zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly {
    override val logType: Option[zio.aws.elasticache.model.LogType] = scala
      .Option(impl.logType())
      .map(value => zio.aws.elasticache.model.LogType.wrap(value))
    override val destinationType
        : Option[zio.aws.elasticache.model.DestinationType] = scala
      .Option(impl.destinationType())
      .map(value => zio.aws.elasticache.model.DestinationType.wrap(value))
    override val destinationDetails
        : Option[zio.aws.elasticache.model.DestinationDetails.ReadOnly] = scala
      .Option(impl.destinationDetails())
      .map(value => zio.aws.elasticache.model.DestinationDetails.wrap(value))
    override val logFormat: Option[zio.aws.elasticache.model.LogFormat] = scala
      .Option(impl.logFormat())
      .map(value => zio.aws.elasticache.model.LogFormat.wrap(value))
    override val status
        : Option[zio.aws.elasticache.model.LogDeliveryConfigurationStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.elasticache.model.LogDeliveryConfigurationStatus.wrap(value)
        )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.LogDeliveryConfiguration
  ): zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
