package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReservedCacheNode(
    reservedCacheNodeId: Option[String] = None,
    reservedCacheNodesOfferingId: Option[String] = None,
    cacheNodeType: Option[String] = None,
    startTime: Option[TStamp] = None,
    duration: Option[Integer] = None,
    fixedPrice: Option[Double] = None,
    usagePrice: Option[Double] = None,
    cacheNodeCount: Option[Integer] = None,
    productDescription: Option[String] = None,
    offeringType: Option[String] = None,
    state: Option[String] = None,
    recurringCharges: Option[
      Iterable[zio.aws.elasticache.model.RecurringCharge]
    ] = None,
    reservationARN: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReservedCacheNode = {
    import ReservedCacheNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
      .builder()
      .optionallyWith(
        reservedCacheNodeId.map(value => value: java.lang.String)
      )(_.reservedCacheNodeId)
      .optionallyWith(
        reservedCacheNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedCacheNodesOfferingId)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        duration.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.duration)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(
        cacheNodeCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.cacheNodeCount)
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(reservationARN.map(value => value: java.lang.String))(
        _.reservationARN
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ReservedCacheNode.ReadOnly =
    zio.aws.elasticache.model.ReservedCacheNode.wrap(buildAwsValue())
}
object ReservedCacheNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ReservedCacheNode =
      zio.aws.elasticache.model.ReservedCacheNode(
        reservedCacheNodeId.map(value => value),
        reservedCacheNodesOfferingId.map(value => value),
        cacheNodeType.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        cacheNodeCount.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        state.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservationARN.map(value => value)
      )
    def reservedCacheNodeId: Option[String]
    def reservedCacheNodesOfferingId: Option[String]
    def cacheNodeType: Option[String]
    def startTime: Option[TStamp]
    def duration: Option[Integer]
    def fixedPrice: Option[Double]
    def usagePrice: Option[Double]
    def cacheNodeCount: Option[Integer]
    def productDescription: Option[String]
    def offeringType: Option[String]
    def state: Option[String]
    def recurringCharges
        : Option[List[zio.aws.elasticache.model.RecurringCharge.ReadOnly]]
    def reservationARN: Option[String]
    def getReservedCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedCacheNodeId", reservedCacheNodeId)
    def getReservedCacheNodesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedCacheNodesOfferingId",
        reservedCacheNodesOfferingId
      )
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCacheNodeCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cacheNodeCount", cacheNodeCount)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getReservationARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservationARN", reservationARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
  ) extends zio.aws.elasticache.model.ReservedCacheNode.ReadOnly {
    override val reservedCacheNodeId: Option[String] =
      scala.Option(impl.reservedCacheNodeId()).map(value => value: String)
    override val reservedCacheNodesOfferingId: Option[String] = scala
      .Option(impl.reservedCacheNodesOfferingId())
      .map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val duration: Option[Integer] = scala
      .Option(impl.duration())
      .map(value => zio.aws.elasticache.model.primitives.Integer(value))
    override val fixedPrice: Option[Double] =
      scala.Option(impl.fixedPrice()).map(value => value: Double)
    override val usagePrice: Option[Double] =
      scala.Option(impl.usagePrice()).map(value => value: Double)
    override val cacheNodeCount: Option[Integer] = scala
      .Option(impl.cacheNodeCount())
      .map(value => zio.aws.elasticache.model.primitives.Integer(value))
    override val productDescription: Option[String] =
      scala.Option(impl.productDescription()).map(value => value: String)
    override val offeringType: Option[String] =
      scala.Option(impl.offeringType()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val recurringCharges
        : Option[List[zio.aws.elasticache.model.RecurringCharge.ReadOnly]] =
      scala
        .Option(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val reservationARN: Option[String] =
      scala.Option(impl.reservationARN()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReservedCacheNode
  ): zio.aws.elasticache.model.ReservedCacheNode.ReadOnly = new Wrapper(impl)
}
