package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotResponse(
    snapshot: Option[zio.aws.elasticache.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.elasticache.model.CreateSnapshotResponse.wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateSnapshotResponse =
      zio.aws.elasticache.model
        .CreateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.elasticache.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse
  ) extends zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.elasticache.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.elasticache.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateSnapshotResponse
  ): zio.aws.elasticache.model.CreateSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
