package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchApplyUpdateActionRequest(
    replicationGroupIds: Option[Iterable[String]] = None,
    cacheClusterIds: Option[Iterable[String]] = None,
    serviceUpdateName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest = {
    import BatchApplyUpdateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
      .builder()
      .optionallyWith(
        replicationGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroupIds)
      .optionallyWith(
        cacheClusterIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheClusterIds)
      .serviceUpdateName(serviceUpdateName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.BatchApplyUpdateActionRequest.ReadOnly =
    zio.aws.elasticache.model.BatchApplyUpdateActionRequest
      .wrap(buildAwsValue())
}
object BatchApplyUpdateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.BatchApplyUpdateActionRequest =
      zio.aws.elasticache.model.BatchApplyUpdateActionRequest(
        replicationGroupIds.map(value => value),
        cacheClusterIds.map(value => value),
        serviceUpdateName
      )
    def replicationGroupIds: Option[List[String]]
    def cacheClusterIds: Option[List[String]]
    def serviceUpdateName: String
    def getReplicationGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroupIds", replicationGroupIds)
    def getCacheClusterIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheClusterIds", cacheClusterIds)
    def getServiceUpdateName: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceUpdateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
  ) extends zio.aws.elasticache.model.BatchApplyUpdateActionRequest.ReadOnly {
    override val replicationGroupIds: Option[List[String]] = scala
      .Option(impl.replicationGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cacheClusterIds: Option[List[String]] = scala
      .Option(impl.cacheClusterIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceUpdateName: String = impl.serviceUpdateName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.BatchApplyUpdateActionRequest
  ): zio.aws.elasticache.model.BatchApplyUpdateActionRequest.ReadOnly =
    new Wrapper(impl)
}
