package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReservedCacheNodesOffering(
    reservedCacheNodesOfferingId: Option[String] = None,
    cacheNodeType: Option[String] = None,
    duration: Option[Integer] = None,
    fixedPrice: Option[Double] = None,
    usagePrice: Option[Double] = None,
    productDescription: Option[String] = None,
    offeringType: Option[String] = None,
    recurringCharges: Option[
      Iterable[zio.aws.elasticache.model.RecurringCharge]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering = {
    import ReservedCacheNodesOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering
      .builder()
      .optionallyWith(
        reservedCacheNodesOfferingId.map(value => value: java.lang.String)
      )(_.reservedCacheNodesOfferingId)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(
        duration.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.duration)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly =
    zio.aws.elasticache.model.ReservedCacheNodesOffering.wrap(buildAwsValue())
}
object ReservedCacheNodesOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ReservedCacheNodesOffering =
      zio.aws.elasticache.model.ReservedCacheNodesOffering(
        reservedCacheNodesOfferingId.map(value => value),
        cacheNodeType.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservedCacheNodesOfferingId: Option[String]
    def cacheNodeType: Option[String]
    def duration: Option[Integer]
    def fixedPrice: Option[Double]
    def usagePrice: Option[Double]
    def productDescription: Option[String]
    def offeringType: Option[String]
    def recurringCharges
        : Option[List[zio.aws.elasticache.model.RecurringCharge.ReadOnly]]
    def getReservedCacheNodesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedCacheNodesOfferingId",
        reservedCacheNodesOfferingId
      )
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering
  ) extends zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly {
    override val reservedCacheNodesOfferingId: Option[String] = scala
      .Option(impl.reservedCacheNodesOfferingId())
      .map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val duration: Option[Integer] = scala
      .Option(impl.duration())
      .map(value => zio.aws.elasticache.model.primitives.Integer(value))
    override val fixedPrice: Option[Double] =
      scala.Option(impl.fixedPrice()).map(value => value: Double)
    override val usagePrice: Option[Double] =
      scala.Option(impl.usagePrice()).map(value => value: Double)
    override val productDescription: Option[String] =
      scala.Option(impl.productDescription()).map(value => value: String)
    override val offeringType: Option[String] =
      scala.Option(impl.offeringType()).map(value => value: String)
    override val recurringCharges
        : Option[List[zio.aws.elasticache.model.RecurringCharge.ReadOnly]] =
      scala
        .Option(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReservedCacheNodesOffering
  ): zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly =
    new Wrapper(impl)
}
