package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyCacheParameterGroupResponse(
    cacheParameterGroupName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse = {
    import ModifyCacheParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse
      .builder()
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly =
    zio.aws.elasticache.model.ModifyCacheParameterGroupResponse
      .wrap(buildAwsValue())
}
object ModifyCacheParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.ModifyCacheParameterGroupResponse =
      zio.aws.elasticache.model.ModifyCacheParameterGroupResponse(
        cacheParameterGroupName.map(value => value)
      )
    def cacheParameterGroupName: Option[String]
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse
  ) extends zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly {
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheParameterGroupResponse
  ): zio.aws.elasticache.model.ModifyCacheParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
