package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyCacheClusterRequest(
    cacheClusterId: String,
    numCacheNodes: Option[IntegerOptional] = None,
    cacheNodeIdsToRemove: Option[Iterable[String]] = None,
    azMode: Option[zio.aws.elasticache.model.AZMode] = None,
    newAvailabilityZones: Option[Iterable[String]] = None,
    cacheSecurityGroupNames: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    preferredMaintenanceWindow: Option[String] = None,
    notificationTopicArn: Option[String] = None,
    cacheParameterGroupName: Option[String] = None,
    notificationTopicStatus: Option[String] = None,
    applyImmediately: Option[Boolean] = None,
    engineVersion: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    cacheNodeType: Option[String] = None,
    authToken: Option[String] = None,
    authTokenUpdateStrategy: Option[
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest = {
    import ModifyCacheClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
      .builder()
      .cacheClusterId(cacheClusterId: java.lang.String)
      .optionallyWith(
        numCacheNodes.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numCacheNodes)
      .optionallyWith(
        cacheNodeIdsToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheNodeIdsToRemove)
      .optionallyWith(azMode.map(value => value.unwrap))(_.azMode)
      .optionallyWith(
        newAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.newAvailabilityZones)
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        notificationTopicStatus.map(value => value: java.lang.String)
      )(_.notificationTopicStatus)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        snapshotRetentionLimit.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.snapshotRetentionLimit)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(authTokenUpdateStrategy.map(value => value.unwrap))(
        _.authTokenUpdateStrategy
      )
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ModifyCacheClusterRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyCacheClusterRequest.wrap(buildAwsValue())
}
object ModifyCacheClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyCacheClusterRequest =
      zio.aws.elasticache.model.ModifyCacheClusterRequest(
        cacheClusterId,
        numCacheNodes.map(value => value),
        cacheNodeIdsToRemove.map(value => value),
        azMode.map(value => value),
        newAvailabilityZones.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        notificationTopicArn.map(value => value),
        cacheParameterGroupName.map(value => value),
        notificationTopicStatus.map(value => value),
        applyImmediately.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        cacheNodeType.map(value => value),
        authToken.map(value => value),
        authTokenUpdateStrategy.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheClusterId: String
    def numCacheNodes: Option[IntegerOptional]
    def cacheNodeIdsToRemove: Option[List[String]]
    def azMode: Option[zio.aws.elasticache.model.AZMode]
    def newAvailabilityZones: Option[List[String]]
    def cacheSecurityGroupNames: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def preferredMaintenanceWindow: Option[String]
    def notificationTopicArn: Option[String]
    def cacheParameterGroupName: Option[String]
    def notificationTopicStatus: Option[String]
    def applyImmediately: Option[Boolean]
    def engineVersion: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def cacheNodeType: Option[String]
    def authToken: Option[String]
    def authTokenUpdateStrategy
        : Option[zio.aws.elasticache.model.AuthTokenUpdateStrategyType]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def getCacheClusterId: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheClusterId)
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getCacheNodeIdsToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheNodeIdsToRemove", cacheNodeIdsToRemove)
    def getAzMode: ZIO[Any, AwsError, zio.aws.elasticache.model.AZMode] =
      AwsError.unwrapOptionField("azMode", azMode)
    def getNewAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("newAvailabilityZones", newAvailabilityZones)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getNotificationTopicStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("notificationTopicStatus", notificationTopicStatus)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getAuthTokenUpdateStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = AwsError.unwrapOptionField(
      "authTokenUpdateStrategy",
      authTokenUpdateStrategy
    )
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
  ) extends zio.aws.elasticache.model.ModifyCacheClusterRequest.ReadOnly {
    override val cacheClusterId: String = impl.cacheClusterId(): String
    override val numCacheNodes: Option[IntegerOptional] = scala
      .Option(impl.numCacheNodes())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val cacheNodeIdsToRemove: Option[List[String]] = scala
      .Option(impl.cacheNodeIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val azMode: Option[zio.aws.elasticache.model.AZMode] = scala
      .Option(impl.azMode())
      .map(value => zio.aws.elasticache.model.AZMode.wrap(value))
    override val newAvailabilityZones: Option[List[String]] = scala
      .Option(impl.newAvailabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cacheSecurityGroupNames: Option[List[String]] = scala
      .Option(impl.cacheSecurityGroupNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val notificationTopicArn: Option[String] =
      scala.Option(impl.notificationTopicArn()).map(value => value: String)
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val notificationTopicStatus: Option[String] =
      scala.Option(impl.notificationTopicStatus()).map(value => value: String)
    override val applyImmediately: Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val authToken: Option[String] =
      scala.Option(impl.authToken()).map(value => value: String)
    override val authTokenUpdateStrategy
        : Option[zio.aws.elasticache.model.AuthTokenUpdateStrategyType] = scala
      .Option(impl.authTokenUpdateStrategy())
      .map(value =>
        zio.aws.elasticache.model.AuthTokenUpdateStrategyType.wrap(value)
      )
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterRequest
  ): zio.aws.elasticache.model.ModifyCacheClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
