package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{IntegerOptional, BooleanOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeUpdateActionsRequest(
    serviceUpdateName: Option[String] = None,
    replicationGroupIds: Option[Iterable[String]] = None,
    cacheClusterIds: Option[Iterable[String]] = None,
    engine: Option[String] = None,
    serviceUpdateStatus: Option[
      Iterable[zio.aws.elasticache.model.ServiceUpdateStatus]
    ] = None,
    serviceUpdateTimeRange: Option[zio.aws.elasticache.model.TimeRangeFilter] =
      None,
    updateActionStatus: Option[
      Iterable[zio.aws.elasticache.model.UpdateActionStatus]
    ] = None,
    showNodeLevelUpdateStatus: Option[BooleanOptional] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest = {
    import DescribeUpdateActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        replicationGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroupIds)
      .optionallyWith(
        cacheClusterIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheClusterIds)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(
        serviceUpdateStatus.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.serviceUpdateStatusWithStrings)
      .optionallyWith(
        serviceUpdateTimeRange.map(value => value.buildAwsValue())
      )(_.serviceUpdateTimeRange)
      .optionallyWith(
        updateActionStatus.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.updateActionStatusWithStrings)
      .optionallyWith(
        showNodeLevelUpdateStatus.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.showNodeLevelUpdateStatus)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeUpdateActionsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeUpdateActionsRequest.wrap(buildAwsValue())
}
object DescribeUpdateActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUpdateActionsRequest =
      zio.aws.elasticache.model.DescribeUpdateActionsRequest(
        serviceUpdateName.map(value => value),
        replicationGroupIds.map(value => value),
        cacheClusterIds.map(value => value),
        engine.map(value => value),
        serviceUpdateStatus.map(value => value),
        serviceUpdateTimeRange.map(value => value.asEditable),
        updateActionStatus.map(value => value),
        showNodeLevelUpdateStatus.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def serviceUpdateName: Option[String]
    def replicationGroupIds: Option[List[String]]
    def cacheClusterIds: Option[List[String]]
    def engine: Option[String]
    def serviceUpdateStatus
        : Option[List[zio.aws.elasticache.model.ServiceUpdateStatus]]
    def serviceUpdateTimeRange
        : Option[zio.aws.elasticache.model.TimeRangeFilter.ReadOnly]
    def updateActionStatus
        : Option[List[zio.aws.elasticache.model.UpdateActionStatus]]
    def showNodeLevelUpdateStatus: Option[BooleanOptional]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getReplicationGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroupIds", replicationGroupIds)
    def getCacheClusterIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheClusterIds", cacheClusterIds)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getServiceUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ServiceUpdateStatus
    ]] = AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getServiceUpdateTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.TimeRangeFilter.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceUpdateTimeRange",
      serviceUpdateTimeRange
    )
    def getUpdateActionStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.UpdateActionStatus
    ]] = AwsError.unwrapOptionField("updateActionStatus", updateActionStatus)
    def getShowNodeLevelUpdateStatus: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "showNodeLevelUpdateStatus",
        showNodeLevelUpdateStatus
      )
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
  ) extends zio.aws.elasticache.model.DescribeUpdateActionsRequest.ReadOnly {
    override val serviceUpdateName: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override val replicationGroupIds: Option[List[String]] = scala
      .Option(impl.replicationGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cacheClusterIds: Option[List[String]] = scala
      .Option(impl.cacheClusterIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val serviceUpdateStatus
        : Option[List[zio.aws.elasticache.model.ServiceUpdateStatus]] = scala
      .Option(impl.serviceUpdateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ServiceUpdateStatus.wrap(item)
        }.toList
      )
    override val serviceUpdateTimeRange
        : Option[zio.aws.elasticache.model.TimeRangeFilter.ReadOnly] = scala
      .Option(impl.serviceUpdateTimeRange())
      .map(value => zio.aws.elasticache.model.TimeRangeFilter.wrap(value))
    override val updateActionStatus
        : Option[List[zio.aws.elasticache.model.UpdateActionStatus]] = scala
      .Option(impl.updateActionStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.UpdateActionStatus.wrap(item)
        }.toList
      )
    override val showNodeLevelUpdateStatus: Option[BooleanOptional] = scala
      .Option(impl.showNodeLevelUpdateStatus())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest
  ): zio.aws.elasticache.model.DescribeUpdateActionsRequest.ReadOnly =
    new Wrapper(impl)
}
