package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCacheParameterGroupResponse(
    cacheParameterGroup: Option[zio.aws.elasticache.model.CacheParameterGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse = {
    import CreateCacheParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse
      .builder()
      .optionallyWith(cacheParameterGroup.map(value => value.buildAwsValue()))(
        _.cacheParameterGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly =
    zio.aws.elasticache.model.CreateCacheParameterGroupResponse
      .wrap(buildAwsValue())
}
object CreateCacheParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.CreateCacheParameterGroupResponse =
      zio.aws.elasticache.model.CreateCacheParameterGroupResponse(
        cacheParameterGroup.map(value => value.asEditable)
      )
    def cacheParameterGroup
        : Option[zio.aws.elasticache.model.CacheParameterGroup.ReadOnly]
    def getCacheParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField("cacheParameterGroup", cacheParameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse
  ) extends zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly {
    override val cacheParameterGroup
        : Option[zio.aws.elasticache.model.CacheParameterGroup.ReadOnly] = scala
      .Option(impl.cacheParameterGroup())
      .map(value => zio.aws.elasticache.model.CacheParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheParameterGroupResponse
  ): zio.aws.elasticache.model.CreateCacheParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
