package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ParameterNameValue(
    parameterName: Option[String] = None,
    parameterValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ParameterNameValue = {
    import ParameterNameValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ParameterNameValue
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ParameterNameValue.ReadOnly =
    zio.aws.elasticache.model.ParameterNameValue.wrap(buildAwsValue())
}
object ParameterNameValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ParameterNameValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ParameterNameValue =
      zio.aws.elasticache.model.ParameterNameValue(
        parameterName.map(value => value),
        parameterValue.map(value => value)
      )
    def parameterName: Option[String]
    def parameterValue: Option[String]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ParameterNameValue
  ) extends zio.aws.elasticache.model.ParameterNameValue.ReadOnly {
    override val parameterName: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val parameterValue: Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ParameterNameValue
  ): zio.aws.elasticache.model.ParameterNameValue.ReadOnly = new Wrapper(impl)
}
