package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyGlobalReplicationGroupRequest(
    globalReplicationGroupId: String,
    applyImmediately: Boolean,
    cacheNodeType: Option[String] = None,
    engineVersion: Option[String] = None,
    cacheParameterGroupName: Option[String] = None,
    globalReplicationGroupDescription: Option[String] = None,
    automaticFailoverEnabled: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest = {
    import ModifyGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupId(globalReplicationGroupId: java.lang.String)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        globalReplicationGroupDescription.map(value => value: java.lang.String)
      )(_.globalReplicationGroupDescription)
      .optionallyWith(
        automaticFailoverEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.automaticFailoverEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object ModifyGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.ModifyGlobalReplicationGroupRequest =
      zio.aws.elasticache.model.ModifyGlobalReplicationGroupRequest(
        globalReplicationGroupId,
        applyImmediately,
        cacheNodeType.map(value => value),
        engineVersion.map(value => value),
        cacheParameterGroupName.map(value => value),
        globalReplicationGroupDescription.map(value => value),
        automaticFailoverEnabled.map(value => value)
      )
    def globalReplicationGroupId: String
    def applyImmediately: Boolean
    def cacheNodeType: Option[String]
    def engineVersion: Option[String]
    def cacheParameterGroupName: Option[String]
    def globalReplicationGroupDescription: Option[String]
    def automaticFailoverEnabled: Option[BooleanOptional]
    def getGlobalReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupId)
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getGlobalReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "globalReplicationGroupDescription",
        globalReplicationGroupDescription
      )
    def getAutomaticFailoverEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "automaticFailoverEnabled",
        automaticFailoverEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.ModifyGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupId: String =
      impl.globalReplicationGroupId(): String
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val globalReplicationGroupDescription: Option[String] = scala
      .Option(impl.globalReplicationGroupDescription())
      .map(value => value: String)
    override val automaticFailoverEnabled: Option[BooleanOptional] = scala
      .Option(impl.automaticFailoverEnabled())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.ModifyGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
