package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicationGroupPendingModifiedValues(
    primaryClusterId: Option[String] = None,
    automaticFailoverStatus: Option[
      zio.aws.elasticache.model.PendingAutomaticFailoverStatus
    ] = None,
    resharding: Option[zio.aws.elasticache.model.ReshardingStatus] = None,
    authTokenStatus: Option[zio.aws.elasticache.model.AuthTokenUpdateStatus] =
      None,
    userGroups: Option[zio.aws.elasticache.model.UserGroupsUpdateStatus] = None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.PendingLogDeliveryConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues = {
    import ReplicationGroupPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues
      .builder()
      .optionallyWith(primaryClusterId.map(value => value: java.lang.String))(
        _.primaryClusterId
      )
      .optionallyWith(automaticFailoverStatus.map(value => value.unwrap))(
        _.automaticFailoverStatus
      )
      .optionallyWith(resharding.map(value => value.buildAwsValue()))(
        _.resharding
      )
      .optionallyWith(authTokenStatus.map(value => value.unwrap))(
        _.authTokenStatus
      )
      .optionallyWith(userGroups.map(value => value.buildAwsValue()))(
        _.userGroups
      )
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly =
    zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues
      .wrap(buildAwsValue())
}
object ReplicationGroupPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues =
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues(
        primaryClusterId.map(value => value),
        automaticFailoverStatus.map(value => value),
        resharding.map(value => value.asEditable),
        authTokenStatus.map(value => value),
        userGroups.map(value => value.asEditable),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def primaryClusterId: Option[String]
    def automaticFailoverStatus
        : Option[zio.aws.elasticache.model.PendingAutomaticFailoverStatus]
    def resharding: Option[zio.aws.elasticache.model.ReshardingStatus.ReadOnly]
    def authTokenStatus: Option[zio.aws.elasticache.model.AuthTokenUpdateStatus]
    def userGroups
        : Option[zio.aws.elasticache.model.UserGroupsUpdateStatus.ReadOnly]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly]
    ]
    def getPrimaryClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryClusterId", primaryClusterId)
    def getAutomaticFailoverStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.PendingAutomaticFailoverStatus
    ] = AwsError.unwrapOptionField(
      "automaticFailoverStatus",
      automaticFailoverStatus
    )
    def getResharding: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReshardingStatus.ReadOnly
    ] = AwsError.unwrapOptionField("resharding", resharding)
    def getAuthTokenStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.AuthTokenUpdateStatus] =
      AwsError.unwrapOptionField("authTokenStatus", authTokenStatus)
    def getUserGroups: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.UserGroupsUpdateStatus.ReadOnly
    ] = AwsError.unwrapOptionField("userGroups", userGroups)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues
  ) extends zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly {
    override val primaryClusterId: Option[String] =
      scala.Option(impl.primaryClusterId()).map(value => value: String)
    override val automaticFailoverStatus
        : Option[zio.aws.elasticache.model.PendingAutomaticFailoverStatus] =
      scala
        .Option(impl.automaticFailoverStatus())
        .map(value =>
          zio.aws.elasticache.model.PendingAutomaticFailoverStatus.wrap(value)
        )
    override val resharding
        : Option[zio.aws.elasticache.model.ReshardingStatus.ReadOnly] = scala
      .Option(impl.resharding())
      .map(value => zio.aws.elasticache.model.ReshardingStatus.wrap(value))
    override val authTokenStatus
        : Option[zio.aws.elasticache.model.AuthTokenUpdateStatus] = scala
      .Option(impl.authTokenStatus())
      .map(value => zio.aws.elasticache.model.AuthTokenUpdateStatus.wrap(value))
    override val userGroups
        : Option[zio.aws.elasticache.model.UserGroupsUpdateStatus.ReadOnly] =
      scala
        .Option(impl.userGroups())
        .map(value =>
          zio.aws.elasticache.model.UserGroupsUpdateStatus.wrap(value)
        )
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.PendingLogDeliveryConfiguration.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.PendingLogDeliveryConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReplicationGroupPendingModifiedValues
  ): zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly =
    new Wrapper(impl)
}
