package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyCacheSubnetGroupResponse(
    cacheSubnetGroup: Option[zio.aws.elasticache.model.CacheSubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse = {
    import ModifyCacheSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse
      .builder()
      .optionallyWith(cacheSubnetGroup.map(value => value.buildAwsValue()))(
        _.cacheSubnetGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly =
    zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse
      .wrap(buildAwsValue())
}
object ModifyCacheSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse =
      zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse(
        cacheSubnetGroup.map(value => value.asEditable)
      )
    def cacheSubnetGroup
        : Option[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly]
    def getCacheSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("cacheSubnetGroup", cacheSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse
  ) extends zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly {
    override val cacheSubnetGroup
        : Option[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly] = scala
      .Option(impl.cacheSubnetGroup())
      .map(value => zio.aws.elasticache.model.CacheSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheSubnetGroupResponse
  ): zio.aws.elasticache.model.ModifyCacheSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
