package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCacheEngineVersionsResponse(
    marker: Option[String] = None,
    cacheEngineVersions: Option[
      Iterable[zio.aws.elasticache.model.CacheEngineVersion]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse = {
    import DescribeCacheEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        cacheEngineVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheEngineVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeCacheEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse =
      zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse(
        marker.map(value => value),
        cacheEngineVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def cacheEngineVersions
        : Option[List[zio.aws.elasticache.model.CacheEngineVersion.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCacheEngineVersions: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheEngineVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheEngineVersions", cacheEngineVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse
  ) extends zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val cacheEngineVersions
        : Option[List[zio.aws.elasticache.model.CacheEngineVersion.ReadOnly]] =
      scala
        .Option(impl.cacheEngineVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.CacheEngineVersion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheEngineVersionsResponse
  ): zio.aws.elasticache.model.DescribeCacheEngineVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
