package zio.aws.elasticache.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{TStamp, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Snapshot(
    snapshotName: Option[String] = None,
    replicationGroupId: Option[String] = None,
    replicationGroupDescription: Option[String] = None,
    cacheClusterId: Option[String] = None,
    snapshotStatus: Option[String] = None,
    snapshotSource: Option[String] = None,
    cacheNodeType: Option[String] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    numCacheNodes: Option[IntegerOptional] = None,
    preferredAvailabilityZone: Option[String] = None,
    preferredOutpostArn: Option[String] = None,
    cacheClusterCreateTime: Option[TStamp] = None,
    preferredMaintenanceWindow: Option[String] = None,
    topicArn: Option[String] = None,
    port: Option[IntegerOptional] = None,
    cacheParameterGroupName: Option[String] = None,
    cacheSubnetGroupName: Option[String] = None,
    vpcId: Option[String] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    numNodeGroups: Option[IntegerOptional] = None,
    automaticFailover: Option[
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = None,
    nodeSnapshots: Option[Iterable[zio.aws.elasticache.model.NodeSnapshot]] =
      None,
    kmsKeyId: Option[String] = None,
    arn: Option[String] = None,
    dataTiering: Option[zio.aws.elasticache.model.DataTieringStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Snapshot
      .builder()
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(
        replicationGroupDescription.map(value => value: java.lang.String)
      )(_.replicationGroupDescription)
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(snapshotStatus.map(value => value: java.lang.String))(
        _.snapshotStatus
      )
      .optionallyWith(snapshotSource.map(value => value: java.lang.String))(
        _.snapshotSource
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        numCacheNodes.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numCacheNodes)
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(
        cacheClusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.cacheClusterCreateTime)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(topicArn.map(value => value: java.lang.String))(
        _.topicArn
      )
      .optionallyWith(
        port.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        snapshotRetentionLimit.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.snapshotRetentionLimit)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(
        numNodeGroups.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.numNodeGroups)
      .optionallyWith(automaticFailover.map(value => value.unwrap))(
        _.automaticFailover
      )
      .optionallyWith(
        nodeSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeSnapshots)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(dataTiering.map(value => value.unwrap))(_.dataTiering)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Snapshot.ReadOnly =
    zio.aws.elasticache.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.Snapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Snapshot =
      zio.aws.elasticache.model.Snapshot(
        snapshotName.map(value => value),
        replicationGroupId.map(value => value),
        replicationGroupDescription.map(value => value),
        cacheClusterId.map(value => value),
        snapshotStatus.map(value => value),
        snapshotSource.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        numCacheNodes.map(value => value),
        preferredAvailabilityZone.map(value => value),
        preferredOutpostArn.map(value => value),
        cacheClusterCreateTime.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        topicArn.map(value => value),
        port.map(value => value),
        cacheParameterGroupName.map(value => value),
        cacheSubnetGroupName.map(value => value),
        vpcId.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        numNodeGroups.map(value => value),
        automaticFailover.map(value => value),
        nodeSnapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        dataTiering.map(value => value)
      )
    def snapshotName: Option[String]
    def replicationGroupId: Option[String]
    def replicationGroupDescription: Option[String]
    def cacheClusterId: Option[String]
    def snapshotStatus: Option[String]
    def snapshotSource: Option[String]
    def cacheNodeType: Option[String]
    def engine: Option[String]
    def engineVersion: Option[String]
    def numCacheNodes: Option[IntegerOptional]
    def preferredAvailabilityZone: Option[String]
    def preferredOutpostArn: Option[String]
    def cacheClusterCreateTime: Option[TStamp]
    def preferredMaintenanceWindow: Option[String]
    def topicArn: Option[String]
    def port: Option[IntegerOptional]
    def cacheParameterGroupName: Option[String]
    def cacheSubnetGroupName: Option[String]
    def vpcId: Option[String]
    def autoMinorVersionUpgrade: Option[Boolean]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def numNodeGroups: Option[IntegerOptional]
    def automaticFailover
        : Option[zio.aws.elasticache.model.AutomaticFailoverStatus]
    def nodeSnapshots
        : Option[List[zio.aws.elasticache.model.NodeSnapshot.ReadOnly]]
    def kmsKeyId: Option[String]
    def arn: Option[String]
    def dataTiering: Option[zio.aws.elasticache.model.DataTieringStatus]
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationGroupDescription",
        replicationGroupDescription
      )
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getSnapshotStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotStatus", snapshotStatus)
    def getSnapshotSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotSource", snapshotSource)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getCacheClusterCreateTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("cacheClusterCreateTime", cacheClusterCreateTime)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getNumNodeGroups: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numNodeGroups", numNodeGroups)
    def getAutomaticFailover: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = AwsError.unwrapOptionField("automaticFailover", automaticFailover)
    def getNodeSnapshots: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("nodeSnapshots", nodeSnapshots)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDataTiering
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DataTieringStatus] =
      AwsError.unwrapOptionField("dataTiering", dataTiering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Snapshot
  ) extends zio.aws.elasticache.model.Snapshot.ReadOnly {
    override val snapshotName: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val replicationGroupDescription: Option[String] = scala
      .Option(impl.replicationGroupDescription())
      .map(value => value: String)
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val snapshotStatus: Option[String] =
      scala.Option(impl.snapshotStatus()).map(value => value: String)
    override val snapshotSource: Option[String] =
      scala.Option(impl.snapshotSource()).map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val numCacheNodes: Option[IntegerOptional] = scala
      .Option(impl.numCacheNodes())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val preferredAvailabilityZone: Option[String] =
      scala.Option(impl.preferredAvailabilityZone()).map(value => value: String)
    override val preferredOutpostArn: Option[String] =
      scala.Option(impl.preferredOutpostArn()).map(value => value: String)
    override val cacheClusterCreateTime: Option[TStamp] = scala
      .Option(impl.cacheClusterCreateTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val topicArn: Option[String] =
      scala.Option(impl.topicArn()).map(value => value: String)
    override val port: Option[IntegerOptional] = scala
      .Option(impl.port())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val cacheSubnetGroupName: Option[String] =
      scala.Option(impl.cacheSubnetGroupName()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[Boolean] =
      scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val numNodeGroups: Option[IntegerOptional] = scala
      .Option(impl.numNodeGroups())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val automaticFailover
        : Option[zio.aws.elasticache.model.AutomaticFailoverStatus] = scala
      .Option(impl.automaticFailover())
      .map(value =>
        zio.aws.elasticache.model.AutomaticFailoverStatus.wrap(value)
      )
    override val nodeSnapshots
        : Option[List[zio.aws.elasticache.model.NodeSnapshot.ReadOnly]] = scala
      .Option(impl.nodeSnapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.NodeSnapshot.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val dataTiering
        : Option[zio.aws.elasticache.model.DataTieringStatus] = scala
      .Option(impl.dataTiering())
      .map(value => zio.aws.elasticache.model.DataTieringStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Snapshot
  ): zio.aws.elasticache.model.Snapshot.ReadOnly = new Wrapper(impl)
}
