package zio.aws.elasticache
import zio.aws.elasticache.model.primitives.{
  UserId,
  UserGroupId,
  AllowedNodeGroupId,
  FilterValue
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.elasticache.model.primitives.UserGroupId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccessString extends Subtype[String]
    type AccessString = zio.aws.elasticache.model.primitives.AccessString.Type
    object AllowedNodeGroupId extends Subtype[String]
    type AllowedNodeGroupId =
      zio.aws.elasticache.model.primitives.AllowedNodeGroupId.Type
    object BooleanOptional extends Subtype[Boolean]
    type BooleanOptional =
      zio.aws.elasticache.model.primitives.BooleanOptional.Type
    object EngineType extends Subtype[String]
    type EngineType = zio.aws.elasticache.model.primitives.EngineType.Type
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.elasticache.model.primitives.FilterName.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.elasticache.model.primitives.FilterValue.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.elasticache.model.primitives.Integer.Type
    object IntegerOptional extends Subtype[Int]
    type IntegerOptional =
      zio.aws.elasticache.model.primitives.IntegerOptional.Type
    object TStamp extends Subtype[Instant]
    type TStamp = zio.aws.elasticache.model.primitives.TStamp.Type
    object UserGroupId extends Subtype[String]
    type UserGroupId = zio.aws.elasticache.model.primitives.UserGroupId.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.elasticache.model.primitives.UserId.Type
    object UserName extends Subtype[String]
    type UserName = zio.aws.elasticache.model.primitives.UserName.Type
  }
  type AvailabilityZonesList = List[String]
  type CacheClusterIdList = List[String]
  type CacheClusterList = List[zio.aws.elasticache.model.CacheCluster]
  type CacheEngineVersionList =
    List[zio.aws.elasticache.model.CacheEngineVersion]
  type CacheNodeIdsList = List[String]
  type CacheNodeList = List[zio.aws.elasticache.model.CacheNode]
  type CacheNodeTypeSpecificParametersList =
    List[zio.aws.elasticache.model.CacheNodeTypeSpecificParameter]
  type CacheNodeTypeSpecificValueList =
    List[zio.aws.elasticache.model.CacheNodeTypeSpecificValue]
  type CacheNodeUpdateStatusList =
    List[zio.aws.elasticache.model.CacheNodeUpdateStatus]
  type CacheParameterGroupList =
    List[zio.aws.elasticache.model.CacheParameterGroup]
  type CacheSecurityGroupMembershipList =
    List[zio.aws.elasticache.model.CacheSecurityGroupMembership]
  type CacheSecurityGroupNameList = List[String]
  type CacheSecurityGroups = List[zio.aws.elasticache.model.CacheSecurityGroup]
  type CacheSubnetGroups = List[zio.aws.elasticache.model.CacheSubnetGroup]
  type ClusterIdList = List[String]
  type CustomerNodeEndpointList =
    List[zio.aws.elasticache.model.CustomerNodeEndpoint]
  type EC2SecurityGroupList = List[zio.aws.elasticache.model.EC2SecurityGroup]
  type EventList = List[zio.aws.elasticache.model.Event]
  type FilterList = List[zio.aws.elasticache.model.Filter]
  type FilterValueList = List[FilterValue]
  type GlobalNodeGroupIdList = List[String]
  type GlobalNodeGroupList = List[zio.aws.elasticache.model.GlobalNodeGroup]
  type GlobalReplicationGroupList =
    List[zio.aws.elasticache.model.GlobalReplicationGroup]
  type GlobalReplicationGroupMemberList =
    List[zio.aws.elasticache.model.GlobalReplicationGroupMember]
  type KeyList = List[String]
  type LogDeliveryConfigurationList =
    List[zio.aws.elasticache.model.LogDeliveryConfiguration]
  type LogDeliveryConfigurationRequestList =
    List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
  type NodeGroupConfigurationList =
    List[zio.aws.elasticache.model.NodeGroupConfiguration]
  type NodeGroupList = List[zio.aws.elasticache.model.NodeGroup]
  type NodeGroupMemberList = List[zio.aws.elasticache.model.NodeGroupMember]
  type NodeGroupMemberUpdateStatusList =
    List[zio.aws.elasticache.model.NodeGroupMemberUpdateStatus]
  type NodeGroupUpdateStatusList =
    List[zio.aws.elasticache.model.NodeGroupUpdateStatus]
  type NodeGroupsToRemoveList = List[AllowedNodeGroupId]
  type NodeGroupsToRetainList = List[AllowedNodeGroupId]
  type NodeSnapshotList = List[zio.aws.elasticache.model.NodeSnapshot]
  type NodeTypeList = List[String]
  type OutpostArnsList = List[String]
  type ParameterNameValueList =
    List[zio.aws.elasticache.model.ParameterNameValue]
  type ParametersList = List[zio.aws.elasticache.model.Parameter]
  type PasswordListInput = List[String]
  type PendingLogDeliveryConfigurationList =
    List[zio.aws.elasticache.model.PendingLogDeliveryConfiguration]
  type PreferredAvailabilityZoneList = List[String]
  type PreferredOutpostArnList = List[String]
  type ProcessedUpdateActionList =
    List[zio.aws.elasticache.model.ProcessedUpdateAction]
  type RecurringChargeList = List[zio.aws.elasticache.model.RecurringCharge]
  type RegionalConfigurationList =
    List[zio.aws.elasticache.model.RegionalConfiguration]
  type RemoveReplicasList = List[String]
  type ReplicaConfigurationList = List[zio.aws.elasticache.model.ConfigureShard]
  type ReplicationGroupIdList = List[String]
  type ReplicationGroupList = List[zio.aws.elasticache.model.ReplicationGroup]
  type ReplicationGroupOutpostArnList = List[String]
  type ReservedCacheNodeList = List[zio.aws.elasticache.model.ReservedCacheNode]
  type ReservedCacheNodesOfferingList =
    List[zio.aws.elasticache.model.ReservedCacheNodesOffering]
  type ReshardingConfigurationList =
    List[zio.aws.elasticache.model.ReshardingConfiguration]
  type SecurityGroupIdsList = List[String]
  type SecurityGroupMembershipList =
    List[zio.aws.elasticache.model.SecurityGroupMembership]
  type ServiceUpdateList = List[zio.aws.elasticache.model.ServiceUpdate]
  type ServiceUpdateStatusList =
    List[zio.aws.elasticache.model.ServiceUpdateStatus]
  type SnapshotArnsList = List[String]
  type SnapshotList = List[zio.aws.elasticache.model.Snapshot]
  type SubnetIdentifierList = List[String]
  type SubnetList = List[zio.aws.elasticache.model.Subnet]
  type TagList = List[zio.aws.elasticache.model.Tag]
  type UGReplicationGroupIdList = List[String]
  type UnprocessedUpdateActionList =
    List[zio.aws.elasticache.model.UnprocessedUpdateAction]
  type UpdateActionList = List[zio.aws.elasticache.model.UpdateAction]
  type UpdateActionStatusList =
    List[zio.aws.elasticache.model.UpdateActionStatus]
  type UserGroupIdList = List[UserGroupId]
  type UserGroupIdListInput = List[UserGroupId]
  type UserGroupList = List[zio.aws.elasticache.model.UserGroup]
  type UserIdList = List[UserId]
  type UserIdListInput = List[UserId]
  type UserList = List[zio.aws.elasticache.model.User]
}
