package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CacheNode(
    cacheNodeId: Option[String] = None,
    cacheNodeStatus: Option[String] = None,
    cacheNodeCreateTime: Option[TStamp] = None,
    endpoint: Option[zio.aws.elasticache.model.Endpoint] = None,
    parameterGroupStatus: Option[String] = None,
    sourceCacheNodeId: Option[String] = None,
    customerAvailabilityZone: Option[String] = None,
    customerOutpostArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheNode = {
    import CacheNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheNode
      .builder()
      .optionallyWith(cacheNodeId.map(value => value: java.lang.String))(
        _.cacheNodeId
      )
      .optionallyWith(cacheNodeStatus.map(value => value: java.lang.String))(
        _.cacheNodeStatus
      )
      .optionallyWith(
        cacheNodeCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.cacheNodeCreateTime)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        parameterGroupStatus.map(value => value: java.lang.String)
      )(_.parameterGroupStatus)
      .optionallyWith(sourceCacheNodeId.map(value => value: java.lang.String))(
        _.sourceCacheNodeId
      )
      .optionallyWith(
        customerAvailabilityZone.map(value => value: java.lang.String)
      )(_.customerAvailabilityZone)
      .optionallyWith(customerOutpostArn.map(value => value: java.lang.String))(
        _.customerOutpostArn
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheNode.ReadOnly =
    zio.aws.elasticache.model.CacheNode.wrap(buildAwsValue())
}
object CacheNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheNode =
      zio.aws.elasticache.model.CacheNode(
        cacheNodeId.map(value => value),
        cacheNodeStatus.map(value => value),
        cacheNodeCreateTime.map(value => value),
        endpoint.map(value => value.asEditable),
        parameterGroupStatus.map(value => value),
        sourceCacheNodeId.map(value => value),
        customerAvailabilityZone.map(value => value),
        customerOutpostArn.map(value => value)
      )
    def cacheNodeId: Option[String]
    def cacheNodeStatus: Option[String]
    def cacheNodeCreateTime: Option[TStamp]
    def endpoint: Option[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def parameterGroupStatus: Option[String]
    def sourceCacheNodeId: Option[String]
    def customerAvailabilityZone: Option[String]
    def customerOutpostArn: Option[String]
    def getCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeId", cacheNodeId)
    def getCacheNodeStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeStatus", cacheNodeStatus)
    def getCacheNodeCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cacheNodeCreateTime", cacheNodeCreateTime)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getParameterGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupStatus", parameterGroupStatus)
    def getSourceCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCacheNodeId", sourceCacheNodeId)
    def getCustomerAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customerAvailabilityZone", customerAvailabilityZone)
    def getCustomerOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOutpostArn", customerOutpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNode
  ) extends zio.aws.elasticache.model.CacheNode.ReadOnly {
    override val cacheNodeId: Option[String] =
      scala.Option(impl.cacheNodeId()).map(value => value: String)
    override val cacheNodeStatus: Option[String] =
      scala.Option(impl.cacheNodeStatus()).map(value => value: String)
    override val cacheNodeCreateTime: Option[TStamp] = scala
      .Option(impl.cacheNodeCreateTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val endpoint: Option[zio.aws.elasticache.model.Endpoint.ReadOnly] =
      scala
        .Option(impl.endpoint())
        .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val parameterGroupStatus: Option[String] =
      scala.Option(impl.parameterGroupStatus()).map(value => value: String)
    override val sourceCacheNodeId: Option[String] =
      scala.Option(impl.sourceCacheNodeId()).map(value => value: String)
    override val customerAvailabilityZone: Option[String] =
      scala.Option(impl.customerAvailabilityZone()).map(value => value: String)
    override val customerOutpostArn: Option[String] =
      scala.Option(impl.customerOutpostArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNode
  ): zio.aws.elasticache.model.CacheNode.ReadOnly = new Wrapper(impl)
}
