package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeServiceUpdatesRequest(
    serviceUpdateName: Option[String] = None,
    serviceUpdateStatus: Option[
      Iterable[zio.aws.elasticache.model.ServiceUpdateStatus]
    ] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest = {
    import DescribeServiceUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        serviceUpdateStatus.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.serviceUpdateStatusWithStrings)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeServiceUpdatesRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeServiceUpdatesRequest
      .wrap(buildAwsValue())
}
object DescribeServiceUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeServiceUpdatesRequest =
      zio.aws.elasticache.model.DescribeServiceUpdatesRequest(
        serviceUpdateName.map(value => value),
        serviceUpdateStatus.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def serviceUpdateName: Option[String]
    def serviceUpdateStatus
        : Option[List[zio.aws.elasticache.model.ServiceUpdateStatus]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getServiceUpdateStatus: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ServiceUpdateStatus
    ]] = AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
  ) extends zio.aws.elasticache.model.DescribeServiceUpdatesRequest.ReadOnly {
    override val serviceUpdateName: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override val serviceUpdateStatus
        : Option[List[zio.aws.elasticache.model.ServiceUpdateStatus]] = scala
      .Option(impl.serviceUpdateStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ServiceUpdateStatus.wrap(item)
        }.toList
      )
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest
  ): zio.aws.elasticache.model.DescribeServiceUpdatesRequest.ReadOnly =
    new Wrapper(impl)
}
