package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCacheSubnetGroupRequest(
    cacheSubnetGroupName: String,
    cacheSubnetGroupDescription: String,
    subnetIds: Iterable[String],
    tags: Option[Iterable[zio.aws.elasticache.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest = {
    import CreateCacheSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest
      .builder()
      .cacheSubnetGroupName(cacheSubnetGroupName: java.lang.String)
      .cacheSubnetGroupDescription(
        cacheSubnetGroupDescription: java.lang.String
      )
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateCacheSubnetGroupRequest.ReadOnly =
    zio.aws.elasticache.model.CreateCacheSubnetGroupRequest
      .wrap(buildAwsValue())
}
object CreateCacheSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheSubnetGroupRequest =
      zio.aws.elasticache.model.CreateCacheSubnetGroupRequest(
        cacheSubnetGroupName,
        cacheSubnetGroupDescription,
        subnetIds,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheSubnetGroupName: String
    def cacheSubnetGroupDescription: String
    def subnetIds: List[String]
    def tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getCacheSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheSubnetGroupName)
    def getCacheSubnetGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheSubnetGroupDescription)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest
  ) extends zio.aws.elasticache.model.CreateCacheSubnetGroupRequest.ReadOnly {
    override val cacheSubnetGroupName: String =
      impl.cacheSubnetGroupName(): String
    override val cacheSubnetGroupDescription: String =
      impl.cacheSubnetGroupDescription(): String
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val tags: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupRequest
  ): zio.aws.elasticache.model.CreateCacheSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
