package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestFailoverResponse(
    replicationGroup: Option[zio.aws.elasticache.model.ReplicationGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.TestFailoverResponse = {
    import TestFailoverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.TestFailoverResponse
      .builder()
      .optionallyWith(replicationGroup.map(value => value.buildAwsValue()))(
        _.replicationGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.TestFailoverResponse.ReadOnly =
    zio.aws.elasticache.model.TestFailoverResponse.wrap(buildAwsValue())
}
object TestFailoverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.TestFailoverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.TestFailoverResponse =
      zio.aws.elasticache.model
        .TestFailoverResponse(replicationGroup.map(value => value.asEditable))
    def replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]
    def getReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField("replicationGroup", replicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.TestFailoverResponse
  ) extends zio.aws.elasticache.model.TestFailoverResponse.ReadOnly {
    override val replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly] = scala
      .Option(impl.replicationGroup())
      .map(value => zio.aws.elasticache.model.ReplicationGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.TestFailoverResponse
  ): zio.aws.elasticache.model.TestFailoverResponse.ReadOnly = new Wrapper(impl)
}
