package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IncreaseReplicaCountResponse(
    replicationGroup: Option[zio.aws.elasticache.model.ReplicationGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse = {
    import IncreaseReplicaCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse
      .builder()
      .optionallyWith(replicationGroup.map(value => value.buildAwsValue()))(
        _.replicationGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly =
    zio.aws.elasticache.model.IncreaseReplicaCountResponse.wrap(buildAwsValue())
}
object IncreaseReplicaCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.IncreaseReplicaCountResponse =
      zio.aws.elasticache.model.IncreaseReplicaCountResponse(
        replicationGroup.map(value => value.asEditable)
      )
    def replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]
    def getReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField("replicationGroup", replicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse
  ) extends zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly {
    override val replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly] = scala
      .Option(impl.replicationGroup())
      .map(value => zio.aws.elasticache.model.ReplicationGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.IncreaseReplicaCountResponse
  ): zio.aws.elasticache.model.IncreaseReplicaCountResponse.ReadOnly =
    new Wrapper(impl)
}
