package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{UserGroupId, EngineType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyUserResponse(
    userId: Option[String] = None,
    userName: Option[String] = None,
    status: Option[String] = None,
    engine: Option[EngineType] = None,
    minimumEngineVersion: Option[String] = None,
    accessString: Option[String] = None,
    userGroupIds: Option[Iterable[UserGroupId]] = None,
    authentication: Option[zio.aws.elasticache.model.Authentication] = None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyUserResponse = {
    import ModifyUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyUserResponse
      .builder()
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        engine.map(value => EngineType.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(accessString.map(value => value: java.lang.String))(
        _.accessString
      )
      .optionallyWith(
        userGroupIds.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIds)
      .optionallyWith(authentication.map(value => value.buildAwsValue()))(
        _.authentication
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ModifyUserResponse.ReadOnly =
    zio.aws.elasticache.model.ModifyUserResponse.wrap(buildAwsValue())
}
object ModifyUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyUserResponse =
      zio.aws.elasticache.model.ModifyUserResponse(
        userId.map(value => value),
        userName.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        minimumEngineVersion.map(value => value),
        accessString.map(value => value),
        userGroupIds.map(value => value),
        authentication.map(value => value.asEditable),
        arn.map(value => value)
      )
    def userId: Option[String]
    def userName: Option[String]
    def status: Option[String]
    def engine: Option[EngineType]
    def minimumEngineVersion: Option[String]
    def accessString: Option[String]
    def userGroupIds: Option[List[UserGroupId]]
    def authentication
        : Option[zio.aws.elasticache.model.Authentication.ReadOnly]
    def arn: Option[String]
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userName", userName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, EngineType] =
      AwsError.unwrapOptionField("engine", engine)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getAccessString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessString", accessString)
    def getUserGroupIds: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIds", userGroupIds)
    def getAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.Authentication.ReadOnly
    ] = AwsError.unwrapOptionField("authentication", authentication)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserResponse
  ) extends zio.aws.elasticache.model.ModifyUserResponse.ReadOnly {
    override val userId: Option[String] =
      scala.Option(impl.userId()).map(value => value: String)
    override val userName: Option[String] =
      scala.Option(impl.userName()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val engine: Option[EngineType] = scala
      .Option(impl.engine())
      .map(value => zio.aws.elasticache.model.primitives.EngineType(value))
    override val minimumEngineVersion: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override val accessString: Option[String] =
      scala.Option(impl.accessString()).map(value => value: String)
    override val userGroupIds: Option[List[UserGroupId]] = scala
      .Option(impl.userGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserGroupId(item)
        }.toList
      )
    override val authentication
        : Option[zio.aws.elasticache.model.Authentication.ReadOnly] = scala
      .Option(impl.authentication())
      .map(value => zio.aws.elasticache.model.Authentication.wrap(value))
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyUserResponse
  ): zio.aws.elasticache.model.ModifyUserResponse.ReadOnly = new Wrapper(impl)
}
