package zio.aws.elasticache.model
import scala.jdk.CollectionConverters._
sealed trait LogType {
  def unwrap: software.amazon.awssdk.services.elasticache.model.LogType
}
object LogType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.LogType
  ): zio.aws.elasticache.model.LogType = value match {
    case software.amazon.awssdk.services.elasticache.model.LogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.LogType.SLOW_LOG =>
      val r = `slow-log`
      r
  }
  case object unknownToSdkVersion extends zio.aws.elasticache.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.LogType =
      software.amazon.awssdk.services.elasticache.model.LogType.UNKNOWN_TO_SDK_VERSION
  }
  case object `slow-log` extends zio.aws.elasticache.model.LogType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.LogType =
      software.amazon.awssdk.services.elasticache.model.LogType.SLOW_LOG
  }
}
