package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait ClusterIssueCode {
  def unwrap: software.amazon.awssdk.services.eks.model.ClusterIssueCode
}
object ClusterIssueCode {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.ClusterIssueCode
  ): zio.aws.eks.model.ClusterIssueCode = value match {
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.CLUSTER_UNREACHABLE =>
      val r = ClusterUnreachable
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.CONFIGURATION_CONFLICT =>
      val r = ConfigurationConflict
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.INTERNAL_FAILURE =>
      val r = InternalFailure
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_LIMIT_EXCEEDED =>
      val r = ResourceLimitExceeded
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_NOT_FOUND =>
      val r = ResourceNotFound
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.IAM_ROLE_NOT_FOUND =>
      val r = IamRoleNotFound
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.VPC_NOT_FOUND =>
      val r = VpcNotFound
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.INSUFFICIENT_FREE_ADDRESSES =>
      val r = InsufficientFreeAddresses
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.EC2_SERVICE_NOT_SUBSCRIBED =>
      val r = Ec2ServiceNotSubscribed
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.EC2_SUBNET_NOT_FOUND =>
      val r = Ec2SubnetNotFound
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.EC2_SECURITY_GROUP_NOT_FOUND =>
      val r = Ec2SecurityGroupNotFound
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_GRANT_REVOKED =>
      val r = KmsGrantRevoked
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_KEY_NOT_FOUND =>
      val r = KmsKeyNotFound
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_KEY_MARKED_FOR_DELETION =>
      val r = KmsKeyMarkedForDeletion
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_KEY_DISABLED =>
      val r = KmsKeyDisabled
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.STS_REGIONAL_ENDPOINT_DISABLED =>
      val r = StsRegionalEndpointDisabled
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.UNSUPPORTED_VERSION =>
      val r = UnsupportedVersion
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.OTHER =>
      val r = Other
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AccessDenied extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.ACCESS_DENIED
  }
  case object ClusterUnreachable extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.CLUSTER_UNREACHABLE
  }
  case object ConfigurationConflict extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.CONFIGURATION_CONFLICT
  }
  case object InternalFailure extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.INTERNAL_FAILURE
  }
  case object ResourceLimitExceeded extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_LIMIT_EXCEEDED
  }
  case object ResourceNotFound extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_NOT_FOUND
  }
  case object IamRoleNotFound extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.IAM_ROLE_NOT_FOUND
  }
  case object VpcNotFound extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.VPC_NOT_FOUND
  }
  case object InsufficientFreeAddresses
      extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.INSUFFICIENT_FREE_ADDRESSES
  }
  case object Ec2ServiceNotSubscribed
      extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.EC2_SERVICE_NOT_SUBSCRIBED
  }
  case object Ec2SubnetNotFound extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.EC2_SUBNET_NOT_FOUND
  }
  case object Ec2SecurityGroupNotFound
      extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.EC2_SECURITY_GROUP_NOT_FOUND
  }
  case object KmsGrantRevoked extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_GRANT_REVOKED
  }
  case object KmsKeyNotFound extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_KEY_NOT_FOUND
  }
  case object KmsKeyMarkedForDeletion
      extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_KEY_MARKED_FOR_DELETION
  }
  case object KmsKeyDisabled extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.KMS_KEY_DISABLED
  }
  case object StsRegionalEndpointDisabled
      extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.STS_REGIONAL_ENDPOINT_DISABLED
  }
  case object UnsupportedVersion extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.UNSUPPORTED_VERSION
  }
  case object Other extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.OTHER
  }
}
