package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAddonConfigurationResponse(
    addonName: Optional[String] = Optional.Absent,
    addonVersion: Optional[String] = Optional.Absent,
    configurationSchema: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationResponse = {
    import DescribeAddonConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationResponse
      .builder()
      .optionallyWith(addonName.map(value => value: java.lang.String))(
        _.addonName
      )
      .optionallyWith(addonVersion.map(value => value: java.lang.String))(
        _.addonVersion
      )
      .optionallyWith(
        configurationSchema.map(value => value: java.lang.String)
      )(_.configurationSchema)
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.DescribeAddonConfigurationResponse.ReadOnly =
    zio.aws.eks.model.DescribeAddonConfigurationResponse.wrap(buildAwsValue())
}
object DescribeAddonConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeAddonConfigurationResponse =
      zio.aws.eks.model.DescribeAddonConfigurationResponse(
        addonName.map(value => value),
        addonVersion.map(value => value),
        configurationSchema.map(value => value)
      )
    def addonName: Optional[String]
    def addonVersion: Optional[String]
    def configurationSchema: Optional[String]
    def getAddonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonName", addonName)
    def getAddonVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addonVersion", addonVersion)
    def getConfigurationSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configurationSchema", configurationSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationResponse
  ) extends zio.aws.eks.model.DescribeAddonConfigurationResponse.ReadOnly {
    override val addonName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonName())
      .map(value => value: String)
    override val addonVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addonVersion())
      .map(value => value: String)
    override val configurationSchema: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSchema())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationResponse
  ): zio.aws.eks.model.DescribeAddonConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
