package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteClusterResponse(
    cluster: Optional[zio.aws.eks.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DeleteClusterResponse = {
    import DeleteClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DeleteClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.DeleteClusterResponse.ReadOnly =
    zio.aws.eks.model.DeleteClusterResponse.wrap(buildAwsValue())
}
object DeleteClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DeleteClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DeleteClusterResponse = zio.aws.eks.model
      .DeleteClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.eks.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DeleteClusterResponse
  ) extends zio.aws.eks.model.DeleteClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.eks.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.eks.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DeleteClusterResponse
  ): zio.aws.eks.model.DeleteClusterResponse.ReadOnly = new Wrapper(impl)
}
