package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingGroup(name: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.AutoScalingGroup = {
    import AutoScalingGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AutoScalingGroup
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.AutoScalingGroup.ReadOnly =
    zio.aws.eks.model.AutoScalingGroup.wrap(buildAwsValue())
}
object AutoScalingGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.AutoScalingGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AutoScalingGroup =
      zio.aws.eks.model.AutoScalingGroup(name.map(value => value))
    def name: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AutoScalingGroup
  ) extends zio.aws.eks.model.AutoScalingGroup.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AutoScalingGroup
  ): zio.aws.eks.model.AutoScalingGroup.ReadOnly = new Wrapper(impl)
}
