package zio.aws.eks
import zio.aws.eks.model.UpdateNodegroupVersionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.eks.model.{
  ListFargateProfilesRequest,
  UpdateClusterVersionRequest,
  UpdateNodegroupVersionRequest,
  DeleteFargateProfileRequest,
  DisassociateIdentityProviderConfigRequest,
  CreateNodegroupRequest,
  DeleteAddonRequest,
  ListIdentityProviderConfigsRequest,
  DescribeAddonRequest,
  ListTagsForResourceRequest,
  DeregisterClusterRequest,
  AssociateIdentityProviderConfigRequest,
  ListUpdatesRequest,
  CreateClusterRequest,
  DescribeAddonConfigurationRequest,
  DescribeUpdateRequest,
  AssociateEncryptionConfigRequest,
  DeleteClusterRequest,
  ListAddonsRequest,
  DescribeIdentityProviderConfigRequest,
  RegisterClusterRequest,
  CreateAddonRequest,
  DeleteNodegroupRequest,
  UntagResourceRequest,
  CreateFargateProfileRequest,
  DescribeClusterRequest,
  UpdateNodegroupConfigRequest,
  DescribeAddonVersionsRequest,
  ListNodegroupsRequest,
  DescribeNodegroupRequest,
  ListClustersRequest,
  UpdateClusterConfigRequest,
  TagResourceRequest,
  DescribeFargateProfileRequest,
  UpdateAddonRequest
}
import software.amazon.awssdk.services.eks.model.{
  AssociateIdentityProviderConfigResponse,
  ListIdentityProviderConfigsResponse,
  CreateNodegroupResponse,
  DescribeUpdateResponse,
  ListNodegroupsResponse,
  UpdateAddonResponse,
  DescribeNodegroupResponse,
  ListAddonsResponse,
  DeleteNodegroupResponse,
  AddonInfo,
  DisassociateIdentityProviderConfigResponse,
  DescribeClusterResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListUpdatesResponse,
  DescribeIdentityProviderConfigResponse,
  CreateClusterResponse,
  DescribeFargateProfileResponse,
  CreateFargateProfileResponse,
  DescribeAddonResponse,
  DeleteAddonResponse,
  IdentityProviderConfig,
  UpdateNodegroupVersionResponse,
  DeleteFargateProfileResponse,
  AssociateEncryptionConfigResponse,
  RegisterClusterResponse,
  ListFargateProfilesResponse,
  DeleteClusterResponse,
  UpdateNodegroupConfigResponse,
  CreateAddonResponse,
  UpdateClusterVersionResponse,
  UpdateClusterConfigResponse,
  TagResourceResponse,
  DescribeAddonConfigurationResponse,
  DeregisterClusterResponse,
  DescribeAddonVersionsResponse,
  ListClustersResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.eks.{
  EksAsyncClientBuilder,
  EksAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.eks.paginators.{
  ListNodegroupsPublisher,
  ListUpdatesPublisher,
  ListAddonsPublisher,
  DescribeAddonVersionsPublisher,
  ListIdentityProviderConfigsPublisher,
  ListFargateProfilesPublisher,
  ListClustersPublisher
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Eks extends AspectSupport[Eks] {
  val api: EksAsyncClient
  def updateClusterVersion(
      request: UpdateClusterVersionRequest
  ): IO[AwsError, zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly]
  def createNodegroup(
      request: CreateNodegroupRequest
  ): IO[AwsError, zio.aws.eks.model.CreateNodegroupResponse.ReadOnly]
  def describeUpdate(
      request: DescribeUpdateRequest
  ): IO[AwsError, zio.aws.eks.model.DescribeUpdateResponse.ReadOnly]
  def describeAddon(
      request: DescribeAddonRequest
  ): IO[AwsError, zio.aws.eks.model.DescribeAddonResponse.ReadOnly]
  def deleteNodegroup(
      request: DeleteNodegroupRequest
  ): IO[AwsError, zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly]
  def listIdentityProviderConfigs(
      request: ListIdentityProviderConfigsRequest
  ): ZStream[Any, AwsError, zio.aws.eks.model.IdentityProviderConfig.ReadOnly]
  def listIdentityProviderConfigsPaginated(
      request: ListIdentityProviderConfigsRequest
  ): IO[
    AwsError,
    zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly
  ]
  def deregisterCluster(
      request: DeregisterClusterRequest
  ): IO[AwsError, zio.aws.eks.model.DeregisterClusterResponse.ReadOnly]
  def describeIdentityProviderConfig(
      request: DescribeIdentityProviderConfigRequest
  ): IO[
    AwsError,
    zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly
  ]
  def describeFargateProfile(
      request: DescribeFargateProfileRequest
  ): IO[AwsError, zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly]
  def createCluster(
      request: CreateClusterRequest
  ): IO[AwsError, zio.aws.eks.model.CreateClusterResponse.ReadOnly]
  def listUpdates(request: ListUpdatesRequest): ZStream[Any, AwsError, String]
  def listUpdatesPaginated(
      request: ListUpdatesRequest
  ): IO[AwsError, zio.aws.eks.model.ListUpdatesResponse.ReadOnly]
  def deleteCluster(
      request: DeleteClusterRequest
  ): IO[AwsError, zio.aws.eks.model.DeleteClusterResponse.ReadOnly]
  def describeAddonVersions(
      request: DescribeAddonVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.eks.model.AddonInfo.ReadOnly]
  def describeAddonVersionsPaginated(
      request: DescribeAddonVersionsRequest
  ): IO[AwsError, zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly]
  def registerCluster(
      request: RegisterClusterRequest
  ): IO[AwsError, zio.aws.eks.model.RegisterClusterResponse.ReadOnly]
  def disassociateIdentityProviderConfig(
      request: DisassociateIdentityProviderConfigRequest
  ): IO[
    AwsError,
    zio.aws.eks.model.DisassociateIdentityProviderConfigResponse.ReadOnly
  ]
  def deleteFargateProfile(
      request: DeleteFargateProfileRequest
  ): IO[AwsError, zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.eks.model.UntagResourceResponse.ReadOnly]
  def listNodegroups(
      request: ListNodegroupsRequest
  ): ZStream[Any, AwsError, String]
  def listNodegroupsPaginated(
      request: ListNodegroupsRequest
  ): IO[AwsError, zio.aws.eks.model.ListNodegroupsResponse.ReadOnly]
  def createAddon(
      request: CreateAddonRequest
  ): IO[AwsError, zio.aws.eks.model.CreateAddonResponse.ReadOnly]
  def updateNodegroupVersion(
      request: UpdateNodegroupVersionRequest
  ): IO[AwsError, ReadOnly]
  def associateEncryptionConfig(
      request: AssociateEncryptionConfigRequest
  ): IO[AwsError, zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly]
  def describeCluster(
      request: DescribeClusterRequest
  ): IO[AwsError, zio.aws.eks.model.DescribeClusterResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.eks.model.ListTagsForResourceResponse.ReadOnly]
  def listClusters(request: ListClustersRequest): ZStream[Any, AwsError, String]
  def listClustersPaginated(
      request: ListClustersRequest
  ): IO[AwsError, zio.aws.eks.model.ListClustersResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.eks.model.TagResourceResponse.ReadOnly]
  def updateAddon(
      request: UpdateAddonRequest
  ): IO[AwsError, zio.aws.eks.model.UpdateAddonResponse.ReadOnly]
  def associateIdentityProviderConfig(
      request: AssociateIdentityProviderConfigRequest
  ): IO[
    AwsError,
    zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly
  ]
  def deleteAddon(
      request: DeleteAddonRequest
  ): IO[AwsError, zio.aws.eks.model.DeleteAddonResponse.ReadOnly]
  def describeNodegroup(
      request: DescribeNodegroupRequest
  ): IO[AwsError, zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly]
  def createFargateProfile(
      request: CreateFargateProfileRequest
  ): IO[AwsError, zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly]
  def updateClusterConfig(
      request: UpdateClusterConfigRequest
  ): IO[AwsError, zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly]
  def updateNodegroupConfig(
      request: UpdateNodegroupConfigRequest
  ): IO[AwsError, zio.aws.eks.model.UpdateNodegroupConfigResponse.ReadOnly]
  def listFargateProfiles(
      request: ListFargateProfilesRequest
  ): ZStream[Any, AwsError, String]
  def listFargateProfilesPaginated(
      request: ListFargateProfilesRequest
  ): IO[AwsError, zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly]
  def describeAddonConfiguration(
      request: DescribeAddonConfigurationRequest
  ): IO[AwsError, zio.aws.eks.model.DescribeAddonConfigurationResponse.ReadOnly]
  def listAddons(request: ListAddonsRequest): ZStream[Any, AwsError, String]
  def listAddonsPaginated(
      request: ListAddonsRequest
  ): IO[AwsError, zio.aws.eks.model.ListAddonsResponse.ReadOnly]
}
object Eks {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Eks] = customized(identity)
  def customized(
      customization: EksAsyncClientBuilder => EksAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Eks] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: EksAsyncClientBuilder => EksAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Eks] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = EksAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[EksAsyncClient, EksAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[EksAsyncClient, EksAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new EksImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class EksImpl[R](
      override val api: EksAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Eks
      with AwsServiceBase[R] {
    override val serviceName: String = "Eks"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EksImpl[R1] = new EksImpl(api, newAspect, r)
    def updateClusterVersion(
        request: UpdateClusterVersionRequest
    ): IO[AwsError, zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.UpdateClusterVersionRequest,
        UpdateClusterVersionResponse
      ]("updateClusterVersion", api.updateClusterVersion)(
        request.buildAwsValue()
      ).map(zio.aws.eks.model.UpdateClusterVersionResponse.wrap)
        .provideEnvironment(r)
    def createNodegroup(
        request: CreateNodegroupRequest
    ): IO[AwsError, zio.aws.eks.model.CreateNodegroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.CreateNodegroupRequest,
        CreateNodegroupResponse
      ]("createNodegroup", api.createNodegroup)(request.buildAwsValue())
        .map(zio.aws.eks.model.CreateNodegroupResponse.wrap)
        .provideEnvironment(r)
    def describeUpdate(
        request: DescribeUpdateRequest
    ): IO[AwsError, zio.aws.eks.model.DescribeUpdateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DescribeUpdateRequest,
        DescribeUpdateResponse
      ]("describeUpdate", api.describeUpdate)(request.buildAwsValue())
        .map(zio.aws.eks.model.DescribeUpdateResponse.wrap)
        .provideEnvironment(r)
    def describeAddon(
        request: DescribeAddonRequest
    ): IO[AwsError, zio.aws.eks.model.DescribeAddonResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DescribeAddonRequest,
        DescribeAddonResponse
      ]("describeAddon", api.describeAddon)(request.buildAwsValue())
        .map(zio.aws.eks.model.DescribeAddonResponse.wrap)
        .provideEnvironment(r)
    def deleteNodegroup(
        request: DeleteNodegroupRequest
    ): IO[AwsError, zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DeleteNodegroupRequest,
        DeleteNodegroupResponse
      ]("deleteNodegroup", api.deleteNodegroup)(request.buildAwsValue())
        .map(zio.aws.eks.model.DeleteNodegroupResponse.wrap)
        .provideEnvironment(r)
    def listIdentityProviderConfigs(
        request: ListIdentityProviderConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.eks.model.IdentityProviderConfig.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest,
      IdentityProviderConfig,
      ListIdentityProviderConfigsPublisher
    ](
      "listIdentityProviderConfigs",
      api.listIdentityProviderConfigsPaginator,
      _.identityProviderConfigs()
    )(request.buildAwsValue())
      .map(item => zio.aws.eks.model.IdentityProviderConfig.wrap(item))
      .provideEnvironment(r)
    def listIdentityProviderConfigsPaginated(
        request: ListIdentityProviderConfigsRequest
    ): IO[
      AwsError,
      zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eks.model.ListIdentityProviderConfigsRequest,
      ListIdentityProviderConfigsResponse
    ]("listIdentityProviderConfigs", api.listIdentityProviderConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.eks.model.ListIdentityProviderConfigsResponse.wrap)
      .provideEnvironment(r)
    def deregisterCluster(
        request: DeregisterClusterRequest
    ): IO[AwsError, zio.aws.eks.model.DeregisterClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DeregisterClusterRequest,
        DeregisterClusterResponse
      ]("deregisterCluster", api.deregisterCluster)(request.buildAwsValue())
        .map(zio.aws.eks.model.DeregisterClusterResponse.wrap)
        .provideEnvironment(r)
    def describeIdentityProviderConfig(
        request: DescribeIdentityProviderConfigRequest
    ): IO[
      AwsError,
      zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigRequest,
      DescribeIdentityProviderConfigResponse
    ]("describeIdentityProviderConfig", api.describeIdentityProviderConfig)(
      request.buildAwsValue()
    ).map(zio.aws.eks.model.DescribeIdentityProviderConfigResponse.wrap)
      .provideEnvironment(r)
    def describeFargateProfile(
        request: DescribeFargateProfileRequest
    ): IO[AwsError, zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DescribeFargateProfileRequest,
        DescribeFargateProfileResponse
      ]("describeFargateProfile", api.describeFargateProfile)(
        request.buildAwsValue()
      ).map(zio.aws.eks.model.DescribeFargateProfileResponse.wrap)
        .provideEnvironment(r)
    def createCluster(
        request: CreateClusterRequest
    ): IO[AwsError, zio.aws.eks.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.CreateClusterRequest,
        CreateClusterResponse
      ]("createCluster", api.createCluster)(request.buildAwsValue())
        .map(zio.aws.eks.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def listUpdates(
        request: ListUpdatesRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.eks.model.ListUpdatesRequest,
      java.lang.String,
      ListUpdatesPublisher
    ]("listUpdates", api.listUpdatesPaginator, _.updateIds())(
      request.buildAwsValue()
    ).map(item => item: String).provideEnvironment(r)
    def listUpdatesPaginated(
        request: ListUpdatesRequest
    ): IO[AwsError, zio.aws.eks.model.ListUpdatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.ListUpdatesRequest,
        ListUpdatesResponse
      ]("listUpdates", api.listUpdates)(request.buildAwsValue())
        .map(zio.aws.eks.model.ListUpdatesResponse.wrap)
        .provideEnvironment(r)
    def deleteCluster(
        request: DeleteClusterRequest
    ): IO[AwsError, zio.aws.eks.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DeleteClusterRequest,
        DeleteClusterResponse
      ]("deleteCluster", api.deleteCluster)(request.buildAwsValue())
        .map(zio.aws.eks.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def describeAddonVersions(
        request: DescribeAddonVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.eks.model.AddonInfo.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest,
        AddonInfo,
        DescribeAddonVersionsPublisher
      ](
        "describeAddonVersions",
        api.describeAddonVersionsPaginator,
        _.addons()
      )(request.buildAwsValue())
        .map(item => zio.aws.eks.model.AddonInfo.wrap(item))
        .provideEnvironment(r)
    def describeAddonVersionsPaginated(
        request: DescribeAddonVersionsRequest
    ): IO[AwsError, zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DescribeAddonVersionsRequest,
        DescribeAddonVersionsResponse
      ]("describeAddonVersions", api.describeAddonVersions)(
        request.buildAwsValue()
      ).map(zio.aws.eks.model.DescribeAddonVersionsResponse.wrap)
        .provideEnvironment(r)
    def registerCluster(
        request: RegisterClusterRequest
    ): IO[AwsError, zio.aws.eks.model.RegisterClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.RegisterClusterRequest,
        RegisterClusterResponse
      ]("registerCluster", api.registerCluster)(request.buildAwsValue())
        .map(zio.aws.eks.model.RegisterClusterResponse.wrap)
        .provideEnvironment(r)
    def disassociateIdentityProviderConfig(
        request: DisassociateIdentityProviderConfigRequest
    ): IO[
      AwsError,
      zio.aws.eks.model.DisassociateIdentityProviderConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eks.model.DisassociateIdentityProviderConfigRequest,
      DisassociateIdentityProviderConfigResponse
    ](
      "disassociateIdentityProviderConfig",
      api.disassociateIdentityProviderConfig
    )(request.buildAwsValue())
      .map(zio.aws.eks.model.DisassociateIdentityProviderConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteFargateProfile(
        request: DeleteFargateProfileRequest
    ): IO[AwsError, zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DeleteFargateProfileRequest,
        DeleteFargateProfileResponse
      ]("deleteFargateProfile", api.deleteFargateProfile)(
        request.buildAwsValue()
      ).map(zio.aws.eks.model.DeleteFargateProfileResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.eks.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.eks.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listNodegroups(
        request: ListNodegroupsRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.eks.model.ListNodegroupsRequest,
      java.lang.String,
      ListNodegroupsPublisher
    ]("listNodegroups", api.listNodegroupsPaginator, _.nodegroups())(
      request.buildAwsValue()
    ).map(item => item: String).provideEnvironment(r)
    def listNodegroupsPaginated(
        request: ListNodegroupsRequest
    ): IO[AwsError, zio.aws.eks.model.ListNodegroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.ListNodegroupsRequest,
        ListNodegroupsResponse
      ]("listNodegroups", api.listNodegroups)(request.buildAwsValue())
        .map(zio.aws.eks.model.ListNodegroupsResponse.wrap)
        .provideEnvironment(r)
    def createAddon(
        request: CreateAddonRequest
    ): IO[AwsError, zio.aws.eks.model.CreateAddonResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.CreateAddonRequest,
        CreateAddonResponse
      ]("createAddon", api.createAddon)(request.buildAwsValue())
        .map(zio.aws.eks.model.CreateAddonResponse.wrap)
        .provideEnvironment(r)
    def updateNodegroupVersion(
        request: UpdateNodegroupVersionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.eks.model.UpdateNodegroupVersionRequest,
      UpdateNodegroupVersionResponse
    ]("updateNodegroupVersion", api.updateNodegroupVersion)(
      request.buildAwsValue()
    ).map(zio.aws.eks.model.UpdateNodegroupVersionResponse.wrap)
      .provideEnvironment(r)
    def associateEncryptionConfig(
        request: AssociateEncryptionConfigRequest
    ): IO[
      AwsError,
      zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eks.model.AssociateEncryptionConfigRequest,
      AssociateEncryptionConfigResponse
    ]("associateEncryptionConfig", api.associateEncryptionConfig)(
      request.buildAwsValue()
    ).map(zio.aws.eks.model.AssociateEncryptionConfigResponse.wrap)
      .provideEnvironment(r)
    def describeCluster(
        request: DescribeClusterRequest
    ): IO[AwsError, zio.aws.eks.model.DescribeClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DescribeClusterRequest,
        DescribeClusterResponse
      ]("describeCluster", api.describeCluster)(request.buildAwsValue())
        .map(zio.aws.eks.model.DescribeClusterResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.eks.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.eks.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def listClusters(
        request: ListClustersRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.eks.model.ListClustersRequest,
      java.lang.String,
      ListClustersPublisher
    ]("listClusters", api.listClustersPaginator, _.clusters())(
      request.buildAwsValue()
    ).map(item => item: String).provideEnvironment(r)
    def listClustersPaginated(
        request: ListClustersRequest
    ): IO[AwsError, zio.aws.eks.model.ListClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.ListClustersRequest,
        ListClustersResponse
      ]("listClusters", api.listClusters)(request.buildAwsValue())
        .map(zio.aws.eks.model.ListClustersResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.eks.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.eks.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateAddon(
        request: UpdateAddonRequest
    ): IO[AwsError, zio.aws.eks.model.UpdateAddonResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.UpdateAddonRequest,
        UpdateAddonResponse
      ]("updateAddon", api.updateAddon)(request.buildAwsValue())
        .map(zio.aws.eks.model.UpdateAddonResponse.wrap)
        .provideEnvironment(r)
    def associateIdentityProviderConfig(
        request: AssociateIdentityProviderConfigRequest
    ): IO[
      AwsError,
      zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigRequest,
      AssociateIdentityProviderConfigResponse
    ]("associateIdentityProviderConfig", api.associateIdentityProviderConfig)(
      request.buildAwsValue()
    ).map(zio.aws.eks.model.AssociateIdentityProviderConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteAddon(
        request: DeleteAddonRequest
    ): IO[AwsError, zio.aws.eks.model.DeleteAddonResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DeleteAddonRequest,
        DeleteAddonResponse
      ]("deleteAddon", api.deleteAddon)(request.buildAwsValue())
        .map(zio.aws.eks.model.DeleteAddonResponse.wrap)
        .provideEnvironment(r)
    def describeNodegroup(
        request: DescribeNodegroupRequest
    ): IO[AwsError, zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.DescribeNodegroupRequest,
        DescribeNodegroupResponse
      ]("describeNodegroup", api.describeNodegroup)(request.buildAwsValue())
        .map(zio.aws.eks.model.DescribeNodegroupResponse.wrap)
        .provideEnvironment(r)
    def createFargateProfile(
        request: CreateFargateProfileRequest
    ): IO[AwsError, zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.CreateFargateProfileRequest,
        CreateFargateProfileResponse
      ]("createFargateProfile", api.createFargateProfile)(
        request.buildAwsValue()
      ).map(zio.aws.eks.model.CreateFargateProfileResponse.wrap)
        .provideEnvironment(r)
    def updateClusterConfig(
        request: UpdateClusterConfigRequest
    ): IO[AwsError, zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.UpdateClusterConfigRequest,
        UpdateClusterConfigResponse
      ]("updateClusterConfig", api.updateClusterConfig)(request.buildAwsValue())
        .map(zio.aws.eks.model.UpdateClusterConfigResponse.wrap)
        .provideEnvironment(r)
    def updateNodegroupConfig(
        request: UpdateNodegroupConfigRequest
    ): IO[AwsError, zio.aws.eks.model.UpdateNodegroupConfigResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.UpdateNodegroupConfigRequest,
        UpdateNodegroupConfigResponse
      ]("updateNodegroupConfig", api.updateNodegroupConfig)(
        request.buildAwsValue()
      ).map(zio.aws.eks.model.UpdateNodegroupConfigResponse.wrap)
        .provideEnvironment(r)
    def listFargateProfiles(
        request: ListFargateProfilesRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest,
      java.lang.String,
      ListFargateProfilesPublisher
    ](
      "listFargateProfiles",
      api.listFargateProfilesPaginator,
      _.fargateProfileNames()
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listFargateProfilesPaginated(
        request: ListFargateProfilesRequest
    ): IO[AwsError, zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.ListFargateProfilesRequest,
        ListFargateProfilesResponse
      ]("listFargateProfiles", api.listFargateProfiles)(request.buildAwsValue())
        .map(zio.aws.eks.model.ListFargateProfilesResponse.wrap)
        .provideEnvironment(r)
    def describeAddonConfiguration(
        request: DescribeAddonConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.eks.model.DescribeAddonConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.eks.model.DescribeAddonConfigurationRequest,
      DescribeAddonConfigurationResponse
    ]("describeAddonConfiguration", api.describeAddonConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.eks.model.DescribeAddonConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listAddons(request: ListAddonsRequest): ZStream[Any, AwsError, String] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.eks.model.ListAddonsRequest,
        java.lang.String,
        ListAddonsPublisher
      ]("listAddons", api.listAddonsPaginator, _.addons())(
        request.buildAwsValue()
      ).map(item => item: String).provideEnvironment(r)
    def listAddonsPaginated(
        request: ListAddonsRequest
    ): IO[AwsError, zio.aws.eks.model.ListAddonsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.eks.model.ListAddonsRequest,
        ListAddonsResponse
      ]("listAddons", api.listAddons)(request.buildAwsValue())
        .map(zio.aws.eks.model.ListAddonsResponse.wrap)
        .provideEnvironment(r)
  }
  def updateClusterVersion(request: UpdateClusterVersionRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.UpdateClusterVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateClusterVersion(request))
  def createNodegroup(request: CreateNodegroupRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.CreateNodegroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNodegroup(request))
  def describeUpdate(request: DescribeUpdateRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUpdate(request))
  def describeAddon(request: DescribeAddonRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeAddonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAddon(request))
  def deleteNodegroup(request: DeleteNodegroupRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DeleteNodegroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNodegroup(request))
  def listIdentityProviderConfigs(
      request: ListIdentityProviderConfigsRequest
  ): ZStream[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.IdentityProviderConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listIdentityProviderConfigs(request))
  def listIdentityProviderConfigsPaginated(
      request: ListIdentityProviderConfigsRequest
  ): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.ListIdentityProviderConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdentityProviderConfigsPaginated(request))
  def deregisterCluster(request: DeregisterClusterRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DeregisterClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterCluster(request))
  def describeIdentityProviderConfig(
      request: DescribeIdentityProviderConfigRequest
  ): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdentityProviderConfig(request))
  def describeFargateProfile(request: DescribeFargateProfileRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeFargateProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFargateProfile(request))
  def createCluster(request: CreateClusterRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def listUpdates(
      request: ListUpdatesRequest
  ): ZStream[zio.aws.eks.Eks, AwsError, String] =
    ZStream.serviceWithStream(_.listUpdates(request))
  def listUpdatesPaginated(request: ListUpdatesRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.ListUpdatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUpdatesPaginated(request))
  def deleteCluster(request: DeleteClusterRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def describeAddonVersions(
      request: DescribeAddonVersionsRequest
  ): ZStream[zio.aws.eks.Eks, AwsError, zio.aws.eks.model.AddonInfo.ReadOnly] =
    ZStream.serviceWithStream(_.describeAddonVersions(request))
  def describeAddonVersionsPaginated(
      request: DescribeAddonVersionsRequest
  ): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeAddonVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAddonVersionsPaginated(request))
  def registerCluster(request: RegisterClusterRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.RegisterClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerCluster(request))
  def disassociateIdentityProviderConfig(
      request: DisassociateIdentityProviderConfigRequest
  ): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DisassociateIdentityProviderConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateIdentityProviderConfig(request))
  def deleteFargateProfile(request: DeleteFargateProfileRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DeleteFargateProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFargateProfile(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listNodegroups(
      request: ListNodegroupsRequest
  ): ZStream[zio.aws.eks.Eks, AwsError, String] =
    ZStream.serviceWithStream(_.listNodegroups(request))
  def listNodegroupsPaginated(request: ListNodegroupsRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.ListNodegroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNodegroupsPaginated(request))
  def createAddon(request: CreateAddonRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.CreateAddonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAddon(request))
  def updateNodegroupVersion(
      request: UpdateNodegroupVersionRequest
  ): ZIO[zio.aws.eks.Eks, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateNodegroupVersion(request))
  def associateEncryptionConfig(request: AssociateEncryptionConfigRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.AssociateEncryptionConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateEncryptionConfig(request))
  def describeCluster(request: DescribeClusterRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCluster(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listClusters(
      request: ListClustersRequest
  ): ZStream[zio.aws.eks.Eks, AwsError, String] =
    ZStream.serviceWithStream(_.listClusters(request))
  def listClustersPaginated(request: ListClustersRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.ListClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateAddon(request: UpdateAddonRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.UpdateAddonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAddon(request))
  def associateIdentityProviderConfig(
      request: AssociateIdentityProviderConfigRequest
  ): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateIdentityProviderConfig(request))
  def deleteAddon(request: DeleteAddonRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DeleteAddonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAddon(request))
  def describeNodegroup(request: DescribeNodegroupRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeNodegroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNodegroup(request))
  def createFargateProfile(request: CreateFargateProfileRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.CreateFargateProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFargateProfile(request))
  def updateClusterConfig(request: UpdateClusterConfigRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.UpdateClusterConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateClusterConfig(request))
  def updateNodegroupConfig(request: UpdateNodegroupConfigRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.UpdateNodegroupConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNodegroupConfig(request))
  def listFargateProfiles(
      request: ListFargateProfilesRequest
  ): ZStream[zio.aws.eks.Eks, AwsError, String] =
    ZStream.serviceWithStream(_.listFargateProfiles(request))
  def listFargateProfilesPaginated(request: ListFargateProfilesRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.ListFargateProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFargateProfilesPaginated(request))
  def describeAddonConfiguration(
      request: DescribeAddonConfigurationRequest
  ): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.DescribeAddonConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAddonConfiguration(request))
  def listAddons(
      request: ListAddonsRequest
  ): ZStream[zio.aws.eks.Eks, AwsError, String] =
    ZStream.serviceWithStream(_.listAddons(request))
  def listAddonsPaginated(request: ListAddonsRequest): ZIO[
    zio.aws.eks.Eks,
    AwsError,
    zio.aws.eks.model.ListAddonsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAddonsPaginated(request))
}
