package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait UpdateParamType {
  def unwrap: software.amazon.awssdk.services.eks.model.UpdateParamType
}
object UpdateParamType {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.UpdateParamType
  ): zio.aws.eks.model.UpdateParamType = value match {
    case software.amazon.awssdk.services.eks.model.UpdateParamType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.VERSION =>
      val r = Version
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.PLATFORM_VERSION =>
      val r = PlatformVersion
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.ENDPOINT_PRIVATE_ACCESS =>
      val r = EndpointPrivateAccess
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.ENDPOINT_PUBLIC_ACCESS =>
      val r = EndpointPublicAccess
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.CLUSTER_LOGGING =>
      val r = ClusterLogging
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.DESIRED_SIZE =>
      val r = DesiredSize
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.LABELS_TO_ADD =>
      val r = LabelsToAdd
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.LABELS_TO_REMOVE =>
      val r = LabelsToRemove
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.TAINTS_TO_ADD =>
      val r = TaintsToAdd
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.TAINTS_TO_REMOVE =>
      val r = TaintsToRemove
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.MAX_SIZE =>
      val r = MaxSize
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.MIN_SIZE =>
      val r = MinSize
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.RELEASE_VERSION =>
      val r = ReleaseVersion
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.PUBLIC_ACCESS_CIDRS =>
      val r = PublicAccessCidrs
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.LAUNCH_TEMPLATE_NAME =>
      val r = LaunchTemplateName
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.LAUNCH_TEMPLATE_VERSION =>
      val r = LaunchTemplateVersion
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.IDENTITY_PROVIDER_CONFIG =>
      val r = IdentityProviderConfig
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.ENCRYPTION_CONFIG =>
      val r = EncryptionConfig
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.ADDON_VERSION =>
      val r = AddonVersion
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.SERVICE_ACCOUNT_ROLE_ARN =>
      val r = ServiceAccountRoleArn
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.RESOLVE_CONFLICTS =>
      val r = ResolveConflicts
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.MAX_UNAVAILABLE =>
      val r = MaxUnavailable
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.MAX_UNAVAILABLE_PERCENTAGE =>
      val r = MaxUnavailablePercentage
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.CONFIGURATION_VALUES =>
      val r = ConfigurationValues
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.SECURITY_GROUPS =>
      val r = SecurityGroups
      r
    case software.amazon.awssdk.services.eks.model.UpdateParamType.SUBNETS =>
      val r = Subnets
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.UNKNOWN_TO_SDK_VERSION
  }
  case object Version extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.VERSION
  }
  case object PlatformVersion extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.PLATFORM_VERSION
  }
  case object EndpointPrivateAccess extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.ENDPOINT_PRIVATE_ACCESS
  }
  case object EndpointPublicAccess extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.ENDPOINT_PUBLIC_ACCESS
  }
  case object ClusterLogging extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.CLUSTER_LOGGING
  }
  case object DesiredSize extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.DESIRED_SIZE
  }
  case object LabelsToAdd extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.LABELS_TO_ADD
  }
  case object LabelsToRemove extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.LABELS_TO_REMOVE
  }
  case object TaintsToAdd extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.TAINTS_TO_ADD
  }
  case object TaintsToRemove extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.TAINTS_TO_REMOVE
  }
  case object MaxSize extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.MAX_SIZE
  }
  case object MinSize extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.MIN_SIZE
  }
  case object ReleaseVersion extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.RELEASE_VERSION
  }
  case object PublicAccessCidrs extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.PUBLIC_ACCESS_CIDRS
  }
  case object LaunchTemplateName extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.LAUNCH_TEMPLATE_NAME
  }
  case object LaunchTemplateVersion extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.LAUNCH_TEMPLATE_VERSION
  }
  case object IdentityProviderConfig extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.IDENTITY_PROVIDER_CONFIG
  }
  case object EncryptionConfig extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.ENCRYPTION_CONFIG
  }
  case object AddonVersion extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.ADDON_VERSION
  }
  case object ServiceAccountRoleArn extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.SERVICE_ACCOUNT_ROLE_ARN
  }
  case object ResolveConflicts extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.RESOLVE_CONFLICTS
  }
  case object MaxUnavailable extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.MAX_UNAVAILABLE
  }
  case object MaxUnavailablePercentage
      extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.MAX_UNAVAILABLE_PERCENTAGE
  }
  case object ConfigurationValues extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.CONFIGURATION_VALUES
  }
  case object SecurityGroups extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.SECURITY_GROUPS
  }
  case object Subnets extends zio.aws.eks.model.UpdateParamType {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.UpdateParamType =
      software.amazon.awssdk.services.eks.model.UpdateParamType.SUBNETS
  }
}
