package zio.aws.eks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{TagValue, TagKey, Timestamp}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FargateProfile(
    fargateProfileName: Optional[String] = Optional.Absent,
    fargateProfileArn: Optional[String] = Optional.Absent,
    clusterName: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    podExecutionRoleArn: Optional[String] = Optional.Absent,
    subnets: Optional[Iterable[String]] = Optional.Absent,
    selectors: Optional[Iterable[zio.aws.eks.model.FargateProfileSelector]] =
      Optional.Absent,
    status: Optional[zio.aws.eks.model.FargateProfileStatus] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.FargateProfile = {
    import FargateProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.FargateProfile
      .builder()
      .optionallyWith(fargateProfileName.map(value => value: java.lang.String))(
        _.fargateProfileName
      )
      .optionallyWith(fargateProfileArn.map(value => value: java.lang.String))(
        _.fargateProfileArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        podExecutionRoleArn.map(value => value: java.lang.String)
      )(_.podExecutionRoleArn)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        selectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.selectors)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.FargateProfile.ReadOnly =
    zio.aws.eks.model.FargateProfile.wrap(buildAwsValue())
}
object FargateProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.FargateProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.FargateProfile =
      zio.aws.eks.model.FargateProfile(
        fargateProfileName.map(value => value),
        fargateProfileArn.map(value => value),
        clusterName.map(value => value),
        createdAt.map(value => value),
        podExecutionRoleArn.map(value => value),
        subnets.map(value => value),
        selectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        tags.map(value => value)
      )
    def fargateProfileName: Optional[String]
    def fargateProfileArn: Optional[String]
    def clusterName: Optional[String]
    def createdAt: Optional[Timestamp]
    def podExecutionRoleArn: Optional[String]
    def subnets: Optional[List[String]]
    def selectors
        : Optional[List[zio.aws.eks.model.FargateProfileSelector.ReadOnly]]
    def status: Optional[zio.aws.eks.model.FargateProfileStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def getFargateProfileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fargateProfileName", fargateProfileName)
    def getFargateProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fargateProfileArn", fargateProfileArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPodExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("podExecutionRoleArn", podExecutionRoleArn)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSelectors: ZIO[Any, AwsError, List[
      zio.aws.eks.model.FargateProfileSelector.ReadOnly
    ]] = AwsError.unwrapOptionField("selectors", selectors)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.FargateProfileStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.FargateProfile
  ) extends zio.aws.eks.model.FargateProfile.ReadOnly {
    override val fargateProfileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fargateProfileName())
      .map(value => value: String)
    override val fargateProfileArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fargateProfileArn())
      .map(value => value: String)
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val podExecutionRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.podExecutionRoleArn())
      .map(value => value: String)
    override val subnets: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val selectors
        : Optional[List[zio.aws.eks.model.FargateProfileSelector.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.FargateProfileSelector.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.eks.model.FargateProfileStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.eks.model.FargateProfileStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.FargateProfile
  ): zio.aws.eks.model.FargateProfile.ReadOnly = new Wrapper(impl)
}
