package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.ErrorCode
  ): zio.aws.eks.model.ErrorCode = value match {
    case software.amazon.awssdk.services.eks.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.SUBNET_NOT_FOUND =>
      val r = SubnetNotFound
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.SECURITY_GROUP_NOT_FOUND =>
      val r = SecurityGroupNotFound
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.ENI_LIMIT_REACHED =>
      val r = EniLimitReached
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.IP_NOT_AVAILABLE =>
      val r = IpNotAvailable
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.OPERATION_NOT_PERMITTED =>
      val r = OperationNotPermitted
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.VPC_ID_NOT_FOUND =>
      val r = VpcIdNotFound
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.UNKNOWN =>
      val r = Unknown
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.NODE_CREATION_FAILURE =>
      val r = NodeCreationFailure
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.POD_EVICTION_FAILURE =>
      val r = PodEvictionFailure
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.INSUFFICIENT_FREE_ADDRESSES =>
      val r = InsufficientFreeAddresses
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.CLUSTER_UNREACHABLE =>
      val r = ClusterUnreachable
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.INSUFFICIENT_NUMBER_OF_REPLICAS =>
      val r = InsufficientNumberOfReplicas
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.CONFIGURATION_CONFLICT =>
      val r = ConfigurationConflict
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.ADMISSION_REQUEST_DENIED =>
      val r = AdmissionRequestDenied
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.UNSUPPORTED_ADDON_MODIFICATION =>
      val r = UnsupportedAddonModification
      r
    case software.amazon.awssdk.services.eks.model.ErrorCode.K8_S_RESOURCE_NOT_FOUND =>
      val r = K8sResourceNotFound
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object SubnetNotFound extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.SUBNET_NOT_FOUND
  }
  case object SecurityGroupNotFound extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.SECURITY_GROUP_NOT_FOUND
  }
  case object EniLimitReached extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.ENI_LIMIT_REACHED
  }
  case object IpNotAvailable extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.IP_NOT_AVAILABLE
  }
  case object AccessDenied extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.ACCESS_DENIED
  }
  case object OperationNotPermitted extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.OPERATION_NOT_PERMITTED
  }
  case object VpcIdNotFound extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.VPC_ID_NOT_FOUND
  }
  case object Unknown extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.UNKNOWN
  }
  case object NodeCreationFailure extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.NODE_CREATION_FAILURE
  }
  case object PodEvictionFailure extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.POD_EVICTION_FAILURE
  }
  case object InsufficientFreeAddresses extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.INSUFFICIENT_FREE_ADDRESSES
  }
  case object ClusterUnreachable extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.CLUSTER_UNREACHABLE
  }
  case object InsufficientNumberOfReplicas extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.INSUFFICIENT_NUMBER_OF_REPLICAS
  }
  case object ConfigurationConflict extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.CONFIGURATION_CONFLICT
  }
  case object AdmissionRequestDenied extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.ADMISSION_REQUEST_DENIED
  }
  case object UnsupportedAddonModification extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.UNSUPPORTED_ADDON_MODIFICATION
  }
  case object K8sResourceNotFound extends zio.aws.eks.model.ErrorCode {
    override def unwrap: software.amazon.awssdk.services.eks.model.ErrorCode =
      software.amazon.awssdk.services.eks.model.ErrorCode.K8_S_RESOURCE_NOT_FOUND
  }
}
