package zio.aws.eks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{
  LabelKey,
  Timestamp,
  TagValue,
  BoxedInteger,
  LabelValue,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Nodegroup(
    nodegroupName: Optional[String] = Optional.Absent,
    nodegroupArn: Optional[String] = Optional.Absent,
    clusterName: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    releaseVersion: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    modifiedAt: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.eks.model.NodegroupStatus] = Optional.Absent,
    capacityType: Optional[zio.aws.eks.model.CapacityTypes] = Optional.Absent,
    scalingConfig: Optional[zio.aws.eks.model.NodegroupScalingConfig] =
      Optional.Absent,
    instanceTypes: Optional[Iterable[String]] = Optional.Absent,
    subnets: Optional[Iterable[String]] = Optional.Absent,
    remoteAccess: Optional[zio.aws.eks.model.RemoteAccessConfig] =
      Optional.Absent,
    amiType: Optional[zio.aws.eks.model.AMITypes] = Optional.Absent,
    nodeRole: Optional[String] = Optional.Absent,
    labels: Optional[Map[LabelKey, LabelValue]] = Optional.Absent,
    taints: Optional[Iterable[zio.aws.eks.model.Taint]] = Optional.Absent,
    resources: Optional[zio.aws.eks.model.NodegroupResources] = Optional.Absent,
    diskSize: Optional[BoxedInteger] = Optional.Absent,
    health: Optional[zio.aws.eks.model.NodegroupHealth] = Optional.Absent,
    updateConfig: Optional[zio.aws.eks.model.NodegroupUpdateConfig] =
      Optional.Absent,
    launchTemplate: Optional[zio.aws.eks.model.LaunchTemplateSpecification] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Nodegroup = {
    import Nodegroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Nodegroup
      .builder()
      .optionallyWith(nodegroupName.map(value => value: java.lang.String))(
        _.nodegroupName
      )
      .optionallyWith(nodegroupArn.map(value => value: java.lang.String))(
        _.nodegroupArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(releaseVersion.map(value => value: java.lang.String))(
        _.releaseVersion
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        modifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAt)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(capacityType.map(value => value.unwrap))(_.capacityType)
      .optionallyWith(scalingConfig.map(value => value.buildAwsValue()))(
        _.scalingConfig
      )
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(remoteAccess.map(value => value.buildAwsValue()))(
        _.remoteAccess
      )
      .optionallyWith(amiType.map(value => value.unwrap))(_.amiType)
      .optionallyWith(nodeRole.map(value => value: java.lang.String))(
        _.nodeRole
      )
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (LabelKey.unwrap(key): java.lang.String) -> (LabelValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .optionallyWith(
        taints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taints)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(diskSize.map(value => value: Integer))(_.diskSize)
      .optionallyWith(health.map(value => value.buildAwsValue()))(_.health)
      .optionallyWith(updateConfig.map(value => value.buildAwsValue()))(
        _.updateConfig
      )
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Nodegroup.ReadOnly =
    zio.aws.eks.model.Nodegroup.wrap(buildAwsValue())
}
object Nodegroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Nodegroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Nodegroup = zio.aws.eks.model.Nodegroup(
      nodegroupName.map(value => value),
      nodegroupArn.map(value => value),
      clusterName.map(value => value),
      version.map(value => value),
      releaseVersion.map(value => value),
      createdAt.map(value => value),
      modifiedAt.map(value => value),
      status.map(value => value),
      capacityType.map(value => value),
      scalingConfig.map(value => value.asEditable),
      instanceTypes.map(value => value),
      subnets.map(value => value),
      remoteAccess.map(value => value.asEditable),
      amiType.map(value => value),
      nodeRole.map(value => value),
      labels.map(value => value),
      taints.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      resources.map(value => value.asEditable),
      diskSize.map(value => value),
      health.map(value => value.asEditable),
      updateConfig.map(value => value.asEditable),
      launchTemplate.map(value => value.asEditable),
      tags.map(value => value)
    )
    def nodegroupName: Optional[String]
    def nodegroupArn: Optional[String]
    def clusterName: Optional[String]
    def version: Optional[String]
    def releaseVersion: Optional[String]
    def createdAt: Optional[Timestamp]
    def modifiedAt: Optional[Timestamp]
    def status: Optional[zio.aws.eks.model.NodegroupStatus]
    def capacityType: Optional[zio.aws.eks.model.CapacityTypes]
    def scalingConfig
        : Optional[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly]
    def instanceTypes: Optional[List[String]]
    def subnets: Optional[List[String]]
    def remoteAccess: Optional[zio.aws.eks.model.RemoteAccessConfig.ReadOnly]
    def amiType: Optional[zio.aws.eks.model.AMITypes]
    def nodeRole: Optional[String]
    def labels: Optional[Map[LabelKey, LabelValue]]
    def taints: Optional[List[zio.aws.eks.model.Taint.ReadOnly]]
    def resources: Optional[zio.aws.eks.model.NodegroupResources.ReadOnly]
    def diskSize: Optional[BoxedInteger]
    def health: Optional[zio.aws.eks.model.NodegroupHealth.ReadOnly]
    def updateConfig: Optional[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly]
    def launchTemplate
        : Optional[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getNodegroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodegroupName", nodegroupName)
    def getNodegroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodegroupArn", nodegroupArn)
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getReleaseVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseVersion", releaseVersion)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.eks.model.NodegroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCapacityType: ZIO[Any, AwsError, zio.aws.eks.model.CapacityTypes] =
      AwsError.unwrapOptionField("capacityType", capacityType)
    def getScalingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.NodegroupScalingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("scalingConfig", scalingConfig)
    def getInstanceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getRemoteAccess
        : ZIO[Any, AwsError, zio.aws.eks.model.RemoteAccessConfig.ReadOnly] =
      AwsError.unwrapOptionField("remoteAccess", remoteAccess)
    def getAmiType: ZIO[Any, AwsError, zio.aws.eks.model.AMITypes] =
      AwsError.unwrapOptionField("amiType", amiType)
    def getNodeRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeRole", nodeRole)
    def getLabels: ZIO[Any, AwsError, Map[LabelKey, LabelValue]] =
      AwsError.unwrapOptionField("labels", labels)
    def getTaints: ZIO[Any, AwsError, List[zio.aws.eks.model.Taint.ReadOnly]] =
      AwsError.unwrapOptionField("taints", taints)
    def getResources
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupResources.ReadOnly] =
      AwsError.unwrapOptionField("resources", resources)
    def getDiskSize: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("diskSize", diskSize)
    def getHealth
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupHealth.ReadOnly] =
      AwsError.unwrapOptionField("health", health)
    def getUpdateConfig
        : ZIO[Any, AwsError, zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] =
      AwsError.unwrapOptionField("updateConfig", updateConfig)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Nodegroup
  ) extends zio.aws.eks.model.Nodegroup.ReadOnly {
    override val nodegroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodegroupName())
      .map(value => value: String)
    override val nodegroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodegroupArn())
      .map(value => value: String)
    override val clusterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val releaseVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseVersion())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val modifiedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedAt())
      .map(value => zio.aws.eks.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.eks.model.NodegroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.eks.model.NodegroupStatus.wrap(value))
    override val capacityType: Optional[zio.aws.eks.model.CapacityTypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityType())
        .map(value => zio.aws.eks.model.CapacityTypes.wrap(value))
    override val scalingConfig
        : Optional[zio.aws.eks.model.NodegroupScalingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingConfig())
        .map(value => zio.aws.eks.model.NodegroupScalingConfig.wrap(value))
    override val instanceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val subnets: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val remoteAccess
        : Optional[zio.aws.eks.model.RemoteAccessConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAccess())
        .map(value => zio.aws.eks.model.RemoteAccessConfig.wrap(value))
    override val amiType: Optional[zio.aws.eks.model.AMITypes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amiType())
        .map(value => zio.aws.eks.model.AMITypes.wrap(value))
    override val nodeRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeRole())
      .map(value => value: String)
    override val labels: Optional[Map[LabelKey, LabelValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.eks.model.primitives
                .LabelKey(key) -> zio.aws.eks.model.primitives.LabelValue(value)
            })
            .toMap
        )
    override val taints: Optional[List[zio.aws.eks.model.Taint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eks.model.Taint.wrap(item)
          }.toList
        )
    override val resources
        : Optional[zio.aws.eks.model.NodegroupResources.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value => zio.aws.eks.model.NodegroupResources.wrap(value))
    override val diskSize: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.diskSize())
      .map(value => value: BoxedInteger)
    override val health: Optional[zio.aws.eks.model.NodegroupHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.health())
        .map(value => zio.aws.eks.model.NodegroupHealth.wrap(value))
    override val updateConfig
        : Optional[zio.aws.eks.model.NodegroupUpdateConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateConfig())
        .map(value => zio.aws.eks.model.NodegroupUpdateConfig.wrap(value))
    override val launchTemplate
        : Optional[zio.aws.eks.model.LaunchTemplateSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplate())
        .map(value => zio.aws.eks.model.LaunchTemplateSpecification.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Nodegroup
  ): zio.aws.eks.model.Nodegroup.ReadOnly = new Wrapper(impl)
}
