package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIdentityProviderConfigResponse(
    identityProviderConfig: Optional[
      zio.aws.eks.model.IdentityProviderConfigResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigResponse = {
    import DescribeIdentityProviderConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigResponse
      .builder()
      .optionallyWith(
        identityProviderConfig.map(value => value.buildAwsValue())
      )(_.identityProviderConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly =
    zio.aws.eks.model.DescribeIdentityProviderConfigResponse
      .wrap(buildAwsValue())
}
object DescribeIdentityProviderConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.DescribeIdentityProviderConfigResponse =
      zio.aws.eks.model.DescribeIdentityProviderConfigResponse(
        identityProviderConfig.map(value => value.asEditable)
      )
    def identityProviderConfig
        : Optional[zio.aws.eks.model.IdentityProviderConfigResponse.ReadOnly]
    def getIdentityProviderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.IdentityProviderConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "identityProviderConfig",
      identityProviderConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigResponse
  ) extends zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly {
    override val identityProviderConfig
        : Optional[zio.aws.eks.model.IdentityProviderConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderConfig())
        .map(value =>
          zio.aws.eks.model.IdentityProviderConfigResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.DescribeIdentityProviderConfigResponse
  ): zio.aws.eks.model.DescribeIdentityProviderConfigResponse.ReadOnly =
    new Wrapper(impl)
}
