package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNodegroupResponse(
    nodegroup: Optional[zio.aws.eks.model.Nodegroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.CreateNodegroupResponse = {
    import CreateNodegroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.CreateNodegroupResponse
      .builder()
      .optionallyWith(nodegroup.map(value => value.buildAwsValue()))(
        _.nodegroup
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.CreateNodegroupResponse.ReadOnly =
    zio.aws.eks.model.CreateNodegroupResponse.wrap(buildAwsValue())
}
object CreateNodegroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.CreateNodegroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.CreateNodegroupResponse =
      zio.aws.eks.model
        .CreateNodegroupResponse(nodegroup.map(value => value.asEditable))
    def nodegroup: Optional[zio.aws.eks.model.Nodegroup.ReadOnly]
    def getNodegroup: ZIO[Any, AwsError, zio.aws.eks.model.Nodegroup.ReadOnly] =
      AwsError.unwrapOptionField("nodegroup", nodegroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.CreateNodegroupResponse
  ) extends zio.aws.eks.model.CreateNodegroupResponse.ReadOnly {
    override val nodegroup: Optional[zio.aws.eks.model.Nodegroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodegroup())
        .map(value => zio.aws.eks.model.Nodegroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.CreateNodegroupResponse
  ): zio.aws.eks.model.CreateNodegroupResponse.ReadOnly = new Wrapper(impl)
}
