package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ControlPlanePlacementResponse(
    groupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ControlPlanePlacementResponse = {
    import ControlPlanePlacementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ControlPlanePlacementResponse
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ControlPlanePlacementResponse.ReadOnly =
    zio.aws.eks.model.ControlPlanePlacementResponse.wrap(buildAwsValue())
}
object ControlPlanePlacementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ControlPlanePlacementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ControlPlanePlacementResponse =
      zio.aws.eks.model
        .ControlPlanePlacementResponse(groupName.map(value => value))
    def groupName: Optional[String]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ControlPlanePlacementResponse
  ) extends zio.aws.eks.model.ControlPlanePlacementResponse.ReadOnly {
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ControlPlanePlacementResponse
  ): zio.aws.eks.model.ControlPlanePlacementResponse.ReadOnly = new Wrapper(
    impl
  )
}
