package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait ConfigStatus {
  def unwrap: software.amazon.awssdk.services.eks.model.ConfigStatus
}
object ConfigStatus {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.ConfigStatus
  ): zio.aws.eks.model.ConfigStatus = value match {
    case software.amazon.awssdk.services.eks.model.ConfigStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.ConfigStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.eks.model.ConfigStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.eks.model.ConfigStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.ConfigStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConfigStatus =
      software.amazon.awssdk.services.eks.model.ConfigStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.eks.model.ConfigStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConfigStatus =
      software.amazon.awssdk.services.eks.model.ConfigStatus.CREATING
  }
  case object DELETING extends zio.aws.eks.model.ConfigStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConfigStatus =
      software.amazon.awssdk.services.eks.model.ConfigStatus.DELETING
  }
  case object ACTIVE extends zio.aws.eks.model.ConfigStatus {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ConfigStatus =
      software.amazon.awssdk.services.eks.model.ConfigStatus.ACTIVE
  }
}
