package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterIssue(
    code: Optional[zio.aws.eks.model.ClusterIssueCode] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    resourceIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ClusterIssue = {
    import ClusterIssue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ClusterIssue
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ClusterIssue.ReadOnly =
    zio.aws.eks.model.ClusterIssue.wrap(buildAwsValue())
}
object ClusterIssue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.ClusterIssue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ClusterIssue =
      zio.aws.eks.model.ClusterIssue(
        code.map(value => value),
        message.map(value => value),
        resourceIds.map(value => value)
      )
    def code: Optional[zio.aws.eks.model.ClusterIssueCode]
    def message: Optional[String]
    def resourceIds: Optional[List[String]]
    def getCode: ZIO[Any, AwsError, zio.aws.eks.model.ClusterIssueCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getResourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ClusterIssue
  ) extends zio.aws.eks.model.ClusterIssue.ReadOnly {
    override val code: Optional[zio.aws.eks.model.ClusterIssueCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.eks.model.ClusterIssueCode.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val resourceIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ClusterIssue
  ): zio.aws.eks.model.ClusterIssue.ReadOnly = new Wrapper(impl)
}
