package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateParam(
    `type`: Optional[zio.aws.eks.model.UpdateParamType] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.UpdateParam = {
    import UpdateParam.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.UpdateParam
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.UpdateParam.ReadOnly =
    zio.aws.eks.model.UpdateParam.wrap(buildAwsValue())
}
object UpdateParam {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.UpdateParam] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.UpdateParam = zio.aws.eks.model
      .UpdateParam(`type`.map(value => value), value.map(value => value))
    def `type`: Optional[zio.aws.eks.model.UpdateParamType]
    def value: Optional[String]
    def getType: ZIO[Any, AwsError, zio.aws.eks.model.UpdateParamType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.UpdateParam
  ) extends zio.aws.eks.model.UpdateParam.ReadOnly {
    override val `type`: Optional[zio.aws.eks.model.UpdateParamType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.eks.model.UpdateParamType.wrap(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.UpdateParam
  ): zio.aws.eks.model.UpdateParam.ReadOnly = new Wrapper(impl)
}
