package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutpostConfigResponse(
    outpostArns: Iterable[String],
    controlPlaneInstanceType: String,
    controlPlanePlacement: Optional[
      zio.aws.eks.model.ControlPlanePlacementResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.OutpostConfigResponse = {
    import OutpostConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.OutpostConfigResponse
      .builder()
      .outpostArns(outpostArns.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .controlPlaneInstanceType(controlPlaneInstanceType: java.lang.String)
      .optionallyWith(
        controlPlanePlacement.map(value => value.buildAwsValue())
      )(_.controlPlanePlacement)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.OutpostConfigResponse.ReadOnly =
    zio.aws.eks.model.OutpostConfigResponse.wrap(buildAwsValue())
}
object OutpostConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.OutpostConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.OutpostConfigResponse =
      zio.aws.eks.model.OutpostConfigResponse(
        outpostArns,
        controlPlaneInstanceType,
        controlPlanePlacement.map(value => value.asEditable)
      )
    def outpostArns: List[String]
    def controlPlaneInstanceType: String
    def controlPlanePlacement
        : Optional[zio.aws.eks.model.ControlPlanePlacementResponse.ReadOnly]
    def getOutpostArns: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(outpostArns)
    def getControlPlaneInstanceType: ZIO[Any, Nothing, String] =
      ZIO.succeed(controlPlaneInstanceType)
    def getControlPlanePlacement: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.ControlPlanePlacementResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("controlPlanePlacement", controlPlanePlacement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.OutpostConfigResponse
  ) extends zio.aws.eks.model.OutpostConfigResponse.ReadOnly {
    override val outpostArns: List[String] = impl
      .outpostArns()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val controlPlaneInstanceType: String =
      impl.controlPlaneInstanceType(): String
    override val controlPlanePlacement
        : Optional[zio.aws.eks.model.ControlPlanePlacementResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlPlanePlacement())
        .map(value =>
          zio.aws.eks.model.ControlPlanePlacementResponse.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.OutpostConfigResponse
  ): zio.aws.eks.model.OutpostConfigResponse.ReadOnly = new Wrapper(impl)
}
