package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.{Capacity, ZeroCapacity}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class NodegroupScalingConfig(
    minSize: Optional[ZeroCapacity] = Optional.Absent,
    maxSize: Optional[Capacity] = Optional.Absent,
    desiredSize: Optional[ZeroCapacity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.NodegroupScalingConfig = {
    import NodegroupScalingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
      .builder()
      .optionallyWith(
        minSize.map(value => ZeroCapacity.unwrap(value): Integer)
      )(_.minSize)
      .optionallyWith(maxSize.map(value => Capacity.unwrap(value): Integer))(
        _.maxSize
      )
      .optionallyWith(
        desiredSize.map(value => ZeroCapacity.unwrap(value): Integer)
      )(_.desiredSize)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.NodegroupScalingConfig.ReadOnly =
    zio.aws.eks.model.NodegroupScalingConfig.wrap(buildAwsValue())
}
object NodegroupScalingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.NodegroupScalingConfig =
      zio.aws.eks.model.NodegroupScalingConfig(
        minSize.map(value => value),
        maxSize.map(value => value),
        desiredSize.map(value => value)
      )
    def minSize: Optional[ZeroCapacity]
    def maxSize: Optional[Capacity]
    def desiredSize: Optional[ZeroCapacity]
    def getMinSize: ZIO[Any, AwsError, ZeroCapacity] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, Capacity] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getDesiredSize: ZIO[Any, AwsError, ZeroCapacity] =
      AwsError.unwrapOptionField("desiredSize", desiredSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
  ) extends zio.aws.eks.model.NodegroupScalingConfig.ReadOnly {
    override val minSize: Optional[ZeroCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.minSize())
      .map(value => zio.aws.eks.model.primitives.ZeroCapacity(value))
    override val maxSize: Optional[Capacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSize())
      .map(value => zio.aws.eks.model.primitives.Capacity(value))
    override val desiredSize: Optional[ZeroCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredSize())
      .map(value => zio.aws.eks.model.primitives.ZeroCapacity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.NodegroupScalingConfig
  ): zio.aws.eks.model.NodegroupScalingConfig.ReadOnly = new Wrapper(impl)
}
