package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait ClusterIssueCode {
  def unwrap: software.amazon.awssdk.services.eks.model.ClusterIssueCode
}
object ClusterIssueCode {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.ClusterIssueCode
  ): zio.aws.eks.model.ClusterIssueCode = value match {
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.CLUSTER_UNREACHABLE =>
      val r = ClusterUnreachable
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.CONFIGURATION_CONFLICT =>
      val r = ConfigurationConflict
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.INTERNAL_FAILURE =>
      val r = InternalFailure
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_LIMIT_EXCEEDED =>
      val r = ResourceLimitExceeded
      r
    case software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_NOT_FOUND =>
      val r = ResourceNotFound
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AccessDenied extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.ACCESS_DENIED
  }
  case object ClusterUnreachable extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.CLUSTER_UNREACHABLE
  }
  case object ConfigurationConflict extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.CONFIGURATION_CONFLICT
  }
  case object InternalFailure extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.INTERNAL_FAILURE
  }
  case object ResourceLimitExceeded extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_LIMIT_EXCEEDED
  }
  case object ResourceNotFound extends zio.aws.eks.model.ClusterIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.ClusterIssueCode =
      software.amazon.awssdk.services.eks.model.ClusterIssueCode.RESOURCE_NOT_FOUND
  }
}
