package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutpostConfigRequest(
    outpostArns: Iterable[String],
    controlPlaneInstanceType: String,
    controlPlanePlacement: Optional[
      zio.aws.eks.model.ControlPlanePlacementRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.OutpostConfigRequest = {
    import OutpostConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.OutpostConfigRequest
      .builder()
      .outpostArns(outpostArns.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .controlPlaneInstanceType(controlPlaneInstanceType: java.lang.String)
      .optionallyWith(
        controlPlanePlacement.map(value => value.buildAwsValue())
      )(_.controlPlanePlacement)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.OutpostConfigRequest.ReadOnly =
    zio.aws.eks.model.OutpostConfigRequest.wrap(buildAwsValue())
}
object OutpostConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.OutpostConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.OutpostConfigRequest =
      zio.aws.eks.model.OutpostConfigRequest(
        outpostArns,
        controlPlaneInstanceType,
        controlPlanePlacement.map(value => value.asEditable)
      )
    def outpostArns: List[String]
    def controlPlaneInstanceType: String
    def controlPlanePlacement
        : Optional[zio.aws.eks.model.ControlPlanePlacementRequest.ReadOnly]
    def getOutpostArns: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(outpostArns)
    def getControlPlaneInstanceType: ZIO[Any, Nothing, String] =
      ZIO.succeed(controlPlaneInstanceType)
    def getControlPlanePlacement: ZIO[
      Any,
      AwsError,
      zio.aws.eks.model.ControlPlanePlacementRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("controlPlanePlacement", controlPlanePlacement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.OutpostConfigRequest
  ) extends zio.aws.eks.model.OutpostConfigRequest.ReadOnly {
    override val outpostArns: List[String] = impl
      .outpostArns()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val controlPlaneInstanceType: String =
      impl.controlPlaneInstanceType(): String
    override val controlPlanePlacement
        : Optional[zio.aws.eks.model.ControlPlanePlacementRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlPlanePlacement())
        .map(value =>
          zio.aws.eks.model.ControlPlanePlacementRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.OutpostConfigRequest
  ): zio.aws.eks.model.OutpostConfigRequest.ReadOnly = new Wrapper(impl)
}
