package zio.aws.eks.model
import scala.jdk.CollectionConverters._
sealed trait NodegroupIssueCode {
  def unwrap: software.amazon.awssdk.services.eks.model.NodegroupIssueCode
}
object NodegroupIssueCode {
  def wrap(
      value: software.amazon.awssdk.services.eks.model.NodegroupIssueCode
  ): zio.aws.eks.model.NodegroupIssueCode = value match {
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_NOT_FOUND =>
      val r = AutoScalingGroupNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_INVALID_CONFIGURATION =>
      val r = AutoScalingGroupInvalidConfiguration
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SECURITY_GROUP_NOT_FOUND =>
      val r = Ec2SecurityGroupNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SECURITY_GROUP_DELETION_FAILURE =>
      val r = Ec2SecurityGroupDeletionFailure
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_NOT_FOUND =>
      val r = Ec2LaunchTemplateNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_VERSION_MISMATCH =>
      val r = Ec2LaunchTemplateVersionMismatch
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_NOT_FOUND =>
      val r = Ec2SubnetNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_INVALID_CONFIGURATION =>
      val r = Ec2SubnetInvalidConfiguration
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_INSTANCE_PROFILE_NOT_FOUND =>
      val r = IamInstanceProfileNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_MISSING_IPV6_ASSIGNMENT =>
      val r = Ec2SubnetMissingIpv6Assignment
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_LIMIT_EXCEEDED =>
      val r = IamLimitExceeded
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_NODE_ROLE_NOT_FOUND =>
      val r = IamNodeRoleNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.NODE_CREATION_FAILURE =>
      val r = NodeCreationFailure
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.ASG_INSTANCE_LAUNCH_FAILURES =>
      val r = AsgInstanceLaunchFailures
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.INSTANCE_LIMIT_EXCEEDED =>
      val r = InstanceLimitExceeded
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.INSUFFICIENT_FREE_ADDRESSES =>
      val r = InsufficientFreeAddresses
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.INTERNAL_FAILURE =>
      val r = InternalFailure
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.CLUSTER_UNREACHABLE =>
      val r = ClusterUnreachable
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AMI_ID_NOT_FOUND =>
      val r = AmiIdNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_OPT_IN_REQUIRED =>
      val r = AutoScalingGroupOptInRequired
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_RATE_LIMIT_EXCEEDED =>
      val r = AutoScalingGroupRateLimitExceeded
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_DELETION_FAILURE =>
      val r = Ec2LaunchTemplateDeletionFailure
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_INVALID_CONFIGURATION =>
      val r = Ec2LaunchTemplateInvalidConfiguration
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_MAX_LIMIT_EXCEEDED =>
      val r = Ec2LaunchTemplateMaxLimitExceeded
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_LIST_TOO_LONG =>
      val r = Ec2SubnetListTooLong
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_THROTTLING =>
      val r = IamThrottling
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.NODE_TERMINATION_FAILURE =>
      val r = NodeTerminationFailure
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.POD_EVICTION_FAILURE =>
      val r = PodEvictionFailure
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.SOURCE_EC2_LAUNCH_TEMPLATE_NOT_FOUND =>
      val r = SourceEc2LaunchTemplateNotFound
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.LIMIT_EXCEEDED =>
      val r = LimitExceeded
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.UNKNOWN =>
      val r = Unknown
      r
    case software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_INSTANCE_REFRESH_ACTIVE =>
      val r = AutoScalingGroupInstanceRefreshActive
      r
  }
  case object unknownToSdkVersion extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AutoScalingGroupNotFound
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_NOT_FOUND
  }
  case object AutoScalingGroupInvalidConfiguration
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_INVALID_CONFIGURATION
  }
  case object Ec2SecurityGroupNotFound
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SECURITY_GROUP_NOT_FOUND
  }
  case object Ec2SecurityGroupDeletionFailure
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SECURITY_GROUP_DELETION_FAILURE
  }
  case object Ec2LaunchTemplateNotFound
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_NOT_FOUND
  }
  case object Ec2LaunchTemplateVersionMismatch
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_VERSION_MISMATCH
  }
  case object Ec2SubnetNotFound extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_NOT_FOUND
  }
  case object Ec2SubnetInvalidConfiguration
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_INVALID_CONFIGURATION
  }
  case object IamInstanceProfileNotFound
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_INSTANCE_PROFILE_NOT_FOUND
  }
  case object Ec2SubnetMissingIpv6Assignment
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_MISSING_IPV6_ASSIGNMENT
  }
  case object IamLimitExceeded extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_LIMIT_EXCEEDED
  }
  case object IamNodeRoleNotFound extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_NODE_ROLE_NOT_FOUND
  }
  case object NodeCreationFailure extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.NODE_CREATION_FAILURE
  }
  case object AsgInstanceLaunchFailures
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.ASG_INSTANCE_LAUNCH_FAILURES
  }
  case object InstanceLimitExceeded
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.INSTANCE_LIMIT_EXCEEDED
  }
  case object InsufficientFreeAddresses
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.INSUFFICIENT_FREE_ADDRESSES
  }
  case object AccessDenied extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.ACCESS_DENIED
  }
  case object InternalFailure extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.INTERNAL_FAILURE
  }
  case object ClusterUnreachable extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.CLUSTER_UNREACHABLE
  }
  case object AmiIdNotFound extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AMI_ID_NOT_FOUND
  }
  case object AutoScalingGroupOptInRequired
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_OPT_IN_REQUIRED
  }
  case object AutoScalingGroupRateLimitExceeded
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_RATE_LIMIT_EXCEEDED
  }
  case object Ec2LaunchTemplateDeletionFailure
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_DELETION_FAILURE
  }
  case object Ec2LaunchTemplateInvalidConfiguration
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_INVALID_CONFIGURATION
  }
  case object Ec2LaunchTemplateMaxLimitExceeded
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_LAUNCH_TEMPLATE_MAX_LIMIT_EXCEEDED
  }
  case object Ec2SubnetListTooLong
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.EC2_SUBNET_LIST_TOO_LONG
  }
  case object IamThrottling extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.IAM_THROTTLING
  }
  case object NodeTerminationFailure
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.NODE_TERMINATION_FAILURE
  }
  case object PodEvictionFailure extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.POD_EVICTION_FAILURE
  }
  case object SourceEc2LaunchTemplateNotFound
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.SOURCE_EC2_LAUNCH_TEMPLATE_NOT_FOUND
  }
  case object LimitExceeded extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.LIMIT_EXCEEDED
  }
  case object Unknown extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.UNKNOWN
  }
  case object AutoScalingGroupInstanceRefreshActive
      extends zio.aws.eks.model.NodegroupIssueCode {
    override def unwrap
        : software.amazon.awssdk.services.eks.model.NodegroupIssueCode =
      software.amazon.awssdk.services.eks.model.NodegroupIssueCode.AUTO_SCALING_GROUP_INSTANCE_REFRESH_ACTIVE
  }
}
