package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Issue(
    code: Optional[zio.aws.eks.model.NodegroupIssueCode] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    resourceIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Issue = {
    import Issue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Issue
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Issue.ReadOnly =
    zio.aws.eks.model.Issue.wrap(buildAwsValue())
}
object Issue {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Issue] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Issue = zio.aws.eks.model.Issue(
      code.map(value => value),
      message.map(value => value),
      resourceIds.map(value => value)
    )
    def code: Optional[zio.aws.eks.model.NodegroupIssueCode]
    def message: Optional[String]
    def resourceIds: Optional[List[String]]
    def getCode: ZIO[Any, AwsError, zio.aws.eks.model.NodegroupIssueCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getResourceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Issue
  ) extends zio.aws.eks.model.Issue.ReadOnly {
    override val code: Optional[zio.aws.eks.model.NodegroupIssueCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.eks.model.NodegroupIssueCode.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val resourceIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Issue
  ): zio.aws.eks.model.Issue.ReadOnly = new Wrapper(impl)
}
