package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.eks.model.primitives.{TagValue, TagKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateIdentityProviderConfigResponse(
    update: Optional[zio.aws.eks.model.Update] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigResponse = {
    import AssociateIdentityProviderConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigResponse
      .builder()
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly =
    zio.aws.eks.model.AssociateIdentityProviderConfigResponse
      .wrap(buildAwsValue())
}
object AssociateIdentityProviderConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.AssociateIdentityProviderConfigResponse =
      zio.aws.eks.model.AssociateIdentityProviderConfigResponse(
        update.map(value => value.asEditable),
        tags.map(value => value)
      )
    def update: Optional[zio.aws.eks.model.Update.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getUpdate: ZIO[Any, AwsError, zio.aws.eks.model.Update.ReadOnly] =
      AwsError.unwrapOptionField("update", update)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigResponse
  ) extends zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly {
    override val update: Optional[zio.aws.eks.model.Update.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.update())
        .map(value => zio.aws.eks.model.Update.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.eks.model.primitives
              .TagKey(key) -> zio.aws.eks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.AssociateIdentityProviderConfigResponse
  ): zio.aws.eks.model.AssociateIdentityProviderConfigResponse.ReadOnly =
    new Wrapper(impl)
}
