package zio.aws.eks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Provider(keyArn: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.eks.model.Provider = {
    import Provider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.Provider
      .builder()
      .optionallyWith(keyArn.map(value => value: java.lang.String))(_.keyArn)
      .build()
  }
  def asReadOnly: zio.aws.eks.model.Provider.ReadOnly =
    zio.aws.eks.model.Provider.wrap(buildAwsValue())
}
object Provider {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eks.model.Provider] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.Provider =
      zio.aws.eks.model.Provider(keyArn.map(value => value))
    def keyArn: Optional[String]
    def getKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyArn", keyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.Provider
  ) extends zio.aws.eks.model.Provider.ReadOnly {
    override val keyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.Provider
  ): zio.aws.eks.model.Provider.ReadOnly = new Wrapper(impl)
}
