package zio.aws.eks.model
import zio.prelude.data.Optional
import zio.aws.eks.model.primitives.ListNodegroupsRequestMaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNodegroupsRequest(
    clusterName: String,
    maxResults: Optional[ListNodegroupsRequestMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eks.model.ListNodegroupsRequest = {
    import ListNodegroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eks.model.ListNodegroupsRequest
      .builder()
      .clusterName(clusterName: java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListNodegroupsRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.eks.model.ListNodegroupsRequest.ReadOnly =
    zio.aws.eks.model.ListNodegroupsRequest.wrap(buildAwsValue())
}
object ListNodegroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eks.model.ListNodegroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eks.model.ListNodegroupsRequest =
      zio.aws.eks.model.ListNodegroupsRequest(
        clusterName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterName: String
    def maxResults: Optional[ListNodegroupsRequestMaxResults]
    def nextToken: Optional[String]
    def getClusterName: ZIO[Any, Nothing, String] = ZIO.succeed(clusterName)
    def getMaxResults: ZIO[Any, AwsError, ListNodegroupsRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eks.model.ListNodegroupsRequest
  ) extends zio.aws.eks.model.ListNodegroupsRequest.ReadOnly {
    override val clusterName: String = impl.clusterName(): String
    override val maxResults: Optional[ListNodegroupsRequestMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.eks.model.primitives.ListNodegroupsRequestMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eks.model.ListNodegroupsRequest
  ): zio.aws.eks.model.ListNodegroupsRequest.ReadOnly = new Wrapper(impl)
}
